/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexValueValidator;
import org.neo4j.kernel.impl.api.ArrayEncoder;
import org.neo4j.util.Preconditions;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class LuceneIndexValueValidator
implements IndexValueValidator {
    public static final int MAX_TERM_LENGTH = 32766;
    private final IndexDescriptor descriptor;
    private final int checkThreshold;

    public LuceneIndexValueValidator(IndexDescriptor descriptor) {
        this.descriptor = descriptor;
        this.checkThreshold = 6553;
    }

    public void validate(Value ... values) {
        for (Value value : values) {
            this.validate(value);
        }
    }

    private void validate(Value value) {
        Preconditions.checkArgument((value != null && value != Values.NO_VALUE ? 1 : 0) != 0, (String)"Null value");
        if (Values.isTextValue((Object)value) && ((TextValue)value).length() >= this.checkThreshold) {
            int length = ((TextValue)value).stringValue().getBytes().length;
            this.validateActualLength(value, length);
        }
        if (Values.isArrayValue((Value)value)) {
            this.validateActualLength(value, ArrayEncoder.encode(value).getBytes().length);
        }
    }

    private void validateActualLength(Value value, int length) {
        if (length > 32766) {
            IndexValueValidator.throwSizeViolationException((IndexDescriptor)this.descriptor, (int)length, (Value[])new Value[]{value});
        }
    }
}

