/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.populator;

import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.schema.SchemaIndex;
import org.neo4j.kernel.api.impl.schema.populator.DefaultNonUniqueIndexSampler;
import org.neo4j.kernel.api.impl.schema.populator.LuceneIndexPopulator;
import org.neo4j.kernel.api.impl.schema.populator.NonUniqueLuceneIndexPopulatingUpdater;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.NonUniqueIndexSampler;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.NodePropertyAccessor;

public class NonUniqueLuceneIndexPopulator
extends LuceneIndexPopulator<SchemaIndex> {
    private final IndexSamplingConfig samplingConfig;
    private final NonUniqueIndexSampler sampler;

    public NonUniqueLuceneIndexPopulator(SchemaIndex luceneIndex, IndexSamplingConfig samplingConfig) {
        super(luceneIndex);
        this.samplingConfig = samplingConfig;
        this.sampler = this.createDefaultSampler();
    }

    public void verifyDeferredConstraints(NodePropertyAccessor accessor) {
    }

    public IndexUpdater newPopulatingUpdater(NodePropertyAccessor nodePropertyAccessor, PageCursorTracer cursorTracer) {
        return new NonUniqueLuceneIndexPopulatingUpdater(this.writer, this.sampler);
    }

    public void includeSample(IndexEntryUpdate<?> update) {
        this.sampler.include(LuceneDocumentStructure.encodedStringValuesForSampling(update.values()));
    }

    public IndexSample sample(PageCursorTracer cursorTracer) {
        return this.sampler.sample(cursorTracer);
    }

    private DefaultNonUniqueIndexSampler createDefaultSampler() {
        return new DefaultNonUniqueIndexSampler(this.samplingConfig.sampleSizeLimit());
    }
}

