/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.KeepOnlyLastCommitDeletionPolicy;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.SnapshotDeletionPolicy;
import org.neo4j.util.FeatureToggles;

public final class IndexWriterConfigs {
    private static final Analyzer KEYWORD_ANALYZER = new KeywordAnalyzer();
    private static final int MAX_BUFFERED_DOCS = FeatureToggles.getInteger(IndexWriterConfigs.class, (String)"max_buffered_docs", (int)100000);
    private static final int POPULATION_MAX_BUFFERED_DOCS = FeatureToggles.getInteger(IndexWriterConfigs.class, (String)"population_max_buffered_docs", (int)-1);
    private static final int MERGE_POLICY_MERGE_FACTOR = FeatureToggles.getInteger(IndexWriterConfigs.class, (String)"merge.factor", (int)2);
    private static final double MERGE_POLICY_NO_CFS_RATIO = FeatureToggles.getDouble(IndexWriterConfigs.class, (String)"nocfs.ratio", (double)1.0);
    private static final double MERGE_POLICY_MIN_MERGE_MB = FeatureToggles.getDouble(IndexWriterConfigs.class, (String)"min.merge", (double)0.1);
    private static final double STANDARD_RAM_BUFFER_SIZE_MB = FeatureToggles.getDouble(IndexWriterConfigs.class, (String)"standard.ram.buffer.size", (double)16.0);
    private static final double POPULATION_RAM_BUFFER_SIZE_MB = FeatureToggles.getDouble(IndexWriterConfigs.class, (String)"population.ram.buffer.size", (double)50.0);

    private IndexWriterConfigs() {
        throw new AssertionError((Object)"Not for instantiation!");
    }

    public static IndexWriterConfig standard() {
        return IndexWriterConfigs.standard(KEYWORD_ANALYZER);
    }

    public static IndexWriterConfig standard(Analyzer analyzer) {
        IndexWriterConfig writerConfig = new IndexWriterConfig(analyzer);
        writerConfig.setMaxBufferedDocs(MAX_BUFFERED_DOCS);
        writerConfig.setIndexDeletionPolicy((IndexDeletionPolicy)new SnapshotDeletionPolicy((IndexDeletionPolicy)new KeepOnlyLastCommitDeletionPolicy()));
        writerConfig.setUseCompoundFile(true);
        writerConfig.setRAMBufferSizeMB(STANDARD_RAM_BUFFER_SIZE_MB);
        LogByteSizeMergePolicy mergePolicy = new LogByteSizeMergePolicy();
        mergePolicy.setNoCFSRatio(MERGE_POLICY_NO_CFS_RATIO);
        mergePolicy.setMinMergeMB(MERGE_POLICY_MIN_MERGE_MB);
        mergePolicy.setMergeFactor(MERGE_POLICY_MERGE_FACTOR);
        writerConfig.setMergePolicy((MergePolicy)mergePolicy);
        return writerConfig;
    }

    public static IndexWriterConfig population() {
        return IndexWriterConfigs.population(KEYWORD_ANALYZER);
    }

    public static IndexWriterConfig population(Analyzer analyzer) {
        IndexWriterConfig writerConfig = IndexWriterConfigs.standard(analyzer);
        writerConfig.setMaxBufferedDocs(POPULATION_MAX_BUFFERED_DOCS);
        writerConfig.setRAMBufferSizeMB(POPULATION_RAM_BUFFER_SIZE_MB);
        return writerConfig;
    }

    public static IndexWriterConfig transactionState(Analyzer analyzer) {
        IndexWriterConfig config = IndexWriterConfigs.standard(analyzer);
        config.setCommitOnClose(false);
        return config;
    }
}

