/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.populator;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.schema.writer.LuceneIndexWriter;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.storageengine.api.IndexEntryUpdate;

public abstract class LuceneIndexPopulatingUpdater
implements IndexUpdater {
    private final LuceneIndexWriter writer;

    public LuceneIndexPopulatingUpdater(LuceneIndexWriter writer) {
        this.writer = writer;
    }

    public void process(IndexEntryUpdate<?> update) {
        long nodeId = update.getEntityId();
        try {
            switch (update.updateMode()) {
                case ADDED: {
                    this.added(update);
                    this.writer.updateDocument(LuceneDocumentStructure.newTermForChangeOrRemove(nodeId), LuceneDocumentStructure.documentRepresentingProperties(nodeId, update.values()));
                    break;
                }
                case CHANGED: {
                    this.changed(update);
                    this.writer.updateDocument(LuceneDocumentStructure.newTermForChangeOrRemove(nodeId), LuceneDocumentStructure.documentRepresentingProperties(nodeId, update.values()));
                    break;
                }
                case REMOVED: {
                    this.removed(update);
                    this.writer.deleteDocuments(LuceneDocumentStructure.newTermForChangeOrRemove(nodeId));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown update mode " + update.updateMode() + " for values " + Arrays.toString(update.values()));
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected abstract void added(IndexEntryUpdate<?> var1);

    protected abstract void changed(IndexEntryUpdate<?> var1);

    protected abstract void removed(IndexEntryUpdate<?> var1);
}

