/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.IOException;
import java.util.List;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.index.AbstractLuceneIndex;
import org.neo4j.kernel.api.impl.index.SearcherReference;
import org.neo4j.kernel.api.impl.index.partition.AbstractIndexPartition;
import org.neo4j.kernel.api.impl.index.partition.IndexPartitionFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.kernel.api.impl.schema.TaskCoordinator;
import org.neo4j.kernel.api.impl.schema.reader.PartitionedValueIndexReader;
import org.neo4j.kernel.api.impl.schema.reader.SimpleValueIndexReader;
import org.neo4j.kernel.api.impl.schema.verification.PartitionedUniquenessVerifier;
import org.neo4j.kernel.api.impl.schema.verification.SimpleUniquenessVerifier;
import org.neo4j.kernel.api.impl.schema.verification.UniquenessVerifier;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.values.storable.Value;

class LuceneSchemaIndex
extends AbstractLuceneIndex<ValueIndexReader> {
    private final IndexSamplingConfig samplingConfig;
    private final TaskCoordinator taskCoordinator = new TaskCoordinator();

    LuceneSchemaIndex(PartitionedIndexStorage indexStorage, IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, IndexPartitionFactory partitionFactory) {
        super(indexStorage, partitionFactory, descriptor);
        this.samplingConfig = samplingConfig;
    }

    public void verifyUniqueness(NodePropertyAccessor accessor, int[] propertyKeyIds) throws IOException, IndexEntryConflictException {
        this.flush(true);
        try (UniquenessVerifier verifier = this.createUniquenessVerifier();){
            verifier.verify(accessor, propertyKeyIds);
        }
    }

    public void verifyUniqueness(NodePropertyAccessor accessor, int[] propertyKeyIds, List<Value[]> updatedValueTuples) throws IOException, IndexEntryConflictException {
        try (UniquenessVerifier verifier = this.createUniquenessVerifier();){
            verifier.verify(accessor, propertyKeyIds, updatedValueTuples);
        }
    }

    @Override
    public void drop() {
        this.taskCoordinator.cancel();
        try {
            TaskCoordinator.awaitCompletion();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while waiting for concurrent tasks to complete.", e);
        }
        super.drop();
    }

    private UniquenessVerifier createUniquenessVerifier() throws IOException {
        this.ensureOpen();
        this.maybeRefreshBlocking();
        List<AbstractIndexPartition> partitions = this.getPartitions();
        return LuceneSchemaIndex.hasSinglePartition(partitions) ? LuceneSchemaIndex.createSimpleUniquenessVerifier(partitions) : LuceneSchemaIndex.createPartitionedUniquenessVerifier(partitions);
    }

    private static UniquenessVerifier createSimpleUniquenessVerifier(List<AbstractIndexPartition> partitions) throws IOException {
        AbstractIndexPartition singlePartition = LuceneSchemaIndex.getFirstPartition(partitions);
        SearcherReference partitionSearcher = singlePartition.acquireSearcher();
        return new SimpleUniquenessVerifier(partitionSearcher);
    }

    private static UniquenessVerifier createPartitionedUniquenessVerifier(List<AbstractIndexPartition> partitions) throws IOException {
        List<SearcherReference> searchers = LuceneSchemaIndex.acquireSearchers(partitions);
        return new PartitionedUniquenessVerifier(searchers);
    }

    @Override
    protected SimpleValueIndexReader createSimpleReader(List<AbstractIndexPartition> partitions) throws IOException {
        AbstractIndexPartition searcher = LuceneSchemaIndex.getFirstPartition(partitions);
        return new SimpleValueIndexReader(searcher.acquireSearcher(), this.descriptor, this.samplingConfig, this.taskCoordinator);
    }

    @Override
    protected PartitionedValueIndexReader createPartitionedReader(List<AbstractIndexPartition> partitions) throws IOException {
        List<SearcherReference> searchers = LuceneSchemaIndex.acquireSearchers(partitions);
        return new PartitionedValueIndexReader(searchers, this.descriptor, this.samplingConfig, this.taskCoordinator);
    }
}

