/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.populator;

import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.schema.SchemaIndex;
import org.neo4j.kernel.api.impl.schema.populator.DefaultNonUniqueIndexSampler;
import org.neo4j.kernel.api.impl.schema.populator.LuceneIndexPopulator;
import org.neo4j.kernel.api.impl.schema.populator.NonUniqueLuceneIndexPopulatingUpdater;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.NonUniqueIndexSampler;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;

public class NonUniqueLuceneIndexPopulator
extends LuceneIndexPopulator<SchemaIndex> {
    private final IndexSamplingConfig samplingConfig;
    private final NonUniqueIndexSampler sampler;

    public NonUniqueLuceneIndexPopulator(SchemaIndex luceneIndex, IndexSamplingConfig samplingConfig) {
        super(luceneIndex);
        this.samplingConfig = samplingConfig;
        this.sampler = this.createDefaultSampler();
    }

    public void verifyDeferredConstraints(NodePropertyAccessor accessor) {
    }

    public IndexUpdater newPopulatingUpdater(NodePropertyAccessor nodePropertyAccessor, CursorContext cursorContext) {
        return new NonUniqueLuceneIndexPopulatingUpdater(this.writer, this.sampler);
    }

    public void includeSample(IndexEntryUpdate<?> update) {
        this.sampler.include(LuceneDocumentStructure.encodedStringValuesForSampling(((ValueIndexEntryUpdate)update).values()));
    }

    public IndexSample sample(CursorContext cursorContext) {
        return this.sampler.sample(cursorContext);
    }

    private DefaultNonUniqueIndexSampler createDefaultSampler() {
        return new DefaultNonUniqueIndexSampler(this.samplingConfig.sampleSizeLimit());
    }
}

