/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.lucene.document.Document;
import org.neo4j.internal.helpers.collection.BoundedIterable;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.impl.index.LucenePartitionAllDocumentsReader;

public class LuceneAllDocumentsReader
implements BoundedIterable<Document> {
    private final List<LucenePartitionAllDocumentsReader> partitionReaders;

    public LuceneAllDocumentsReader(List<LucenePartitionAllDocumentsReader> partitionReaders) {
        this.partitionReaders = partitionReaders;
    }

    public long maxCount() {
        return this.partitionReaders.stream().mapToLong(LucenePartitionAllDocumentsReader::maxCount).sum();
    }

    public Iterator<Document> iterator() {
        Iterator iterators = this.partitionReaders.stream().map(LucenePartitionAllDocumentsReader::iterator).collect(Collectors.toList()).iterator();
        return Iterators.concat(iterators);
    }

    public List<Iterator<Document>> partition(int numPartitions) {
        int partitionsPerIndexPartition = Math.max(1, numPartitions / this.partitionReaders.size());
        ArrayList<Iterator<Document>> result = new ArrayList<Iterator<Document>>();
        for (LucenePartitionAllDocumentsReader partitionReader : this.partitionReaders) {
            int indexPartitionMaxCount = Math.toIntExact(partitionReader.maxCount());
            int roughCountPerIndexPartition = indexPartitionMaxCount / partitionsPerIndexPartition;
            for (int i = 0; i < partitionsPerIndexPartition; ++i) {
                int from = i * roughCountPerIndexPartition;
                int to = i == partitionsPerIndexPartition - 1 ? indexPartitionMaxCount : from + roughCountPerIndexPartition;
                result.add(partitionReader.iterator(from, to));
            }
        }
        return result;
    }

    public void close() throws IOException {
        IOUtils.closeAll(this.partitionReaders);
    }
}

