/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.sampler;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.util.BytesRef;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.impl.schema.TaskCoordinator;
import org.neo4j.kernel.api.impl.schema.populator.DefaultNonUniqueIndexSampler;
import org.neo4j.kernel.api.impl.schema.sampler.LuceneIndexSampler;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;

public class NonUniqueLuceneIndexSampler
extends LuceneIndexSampler {
    private final IndexSearcher indexSearcher;
    private final IndexSamplingConfig indexSamplingConfig;

    public NonUniqueLuceneIndexSampler(IndexSearcher indexSearcher, TaskCoordinator taskCoordinator, IndexSamplingConfig indexSamplingConfig) {
        super(taskCoordinator);
        this.indexSearcher = indexSearcher;
        this.indexSamplingConfig = indexSamplingConfig;
    }

    public IndexSample sampleIndex(CursorContext cursorContext) throws IndexNotFoundKernelException {
        try (TaskCoordinator.Task task = this.newTask();){
            DefaultNonUniqueIndexSampler sampler = new DefaultNonUniqueIndexSampler(this.indexSamplingConfig.sampleSizeLimit());
            IndexReader indexReader = this.indexSearcher.getIndexReader();
            for (LeafReaderContext readerContext : indexReader.leaves()) {
                try {
                    Set<String> fieldNames = NonUniqueLuceneIndexSampler.getFieldNamesToSample(readerContext);
                    for (String fieldName : fieldNames) {
                        BytesRef termsRef;
                        Terms terms = readerContext.reader().terms(fieldName);
                        if (terms == null) continue;
                        TermsEnum termsEnum = terms.iterator();
                        while ((termsRef = termsEnum.next()) != null) {
                            sampler.include(termsRef.utf8ToString(), termsEnum.docFreq());
                            NonUniqueLuceneIndexSampler.checkCancellation(task);
                        }
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            IndexSample indexSample = sampler.sample(indexReader.numDocs(), cursorContext);
            return indexSample;
        }
    }

    private static Set<String> getFieldNamesToSample(LeafReaderContext readerContext) {
        HashSet<String> fieldNames = new HashSet<String>();
        LeafReader reader = readerContext.reader();
        reader.getFieldInfos().forEach(info -> {
            String name = info.name;
            if (!"id".equals(name)) {
                fieldNames.add(name);
            }
        });
        return fieldNames;
    }
}

