/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.sampler;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.search.IndexSearcher;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.impl.schema.TaskCoordinator;
import org.neo4j.kernel.api.impl.schema.sampler.LuceneIndexSampler;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.UniqueIndexSampler;

public class UniqueLuceneIndexSampler
extends LuceneIndexSampler {
    private final IndexSearcher indexSearcher;

    public UniqueLuceneIndexSampler(IndexSearcher indexSearcher, TaskCoordinator taskCoordinator) {
        super(taskCoordinator);
        this.indexSearcher = indexSearcher;
    }

    public IndexSample sampleIndex(CursorContext cursorContext, AtomicBoolean stopped) throws IndexNotFoundKernelException {
        try (TaskCoordinator.Task task = this.newTask();){
            UniqueIndexSampler sampler = new UniqueIndexSampler();
            sampler.increment((long)this.indexSearcher.getIndexReader().numDocs());
            UniqueLuceneIndexSampler.checkCancellation(task);
            IndexSample indexSample = sampler.result();
            return indexSample;
        }
    }
}

