/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.collector;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.DocIdSetBuilder;
import org.neo4j.internal.helpers.collection.ArrayIterator;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.api.impl.index.collector.ValuesIterator;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.util.VisibleForTesting;
import org.neo4j.values.storable.Value;

public class DocValuesCollector
extends SimpleCollector {
    private LeafReaderContext context;
    private int segmentHits;
    private int totalHits;
    private Scorable scorer;
    private float[] scores;
    private final boolean keepScores;
    private final List<MatchingDocs> matchingDocs = new ArrayList<MatchingDocs>();
    private Docs docs;

    public DocValuesCollector() {
        this(false);
    }

    public DocValuesCollector(boolean keepScores) {
        this.keepScores = keepScores;
    }

    public IndexProgressor getIndexProgressor(String field, IndexProgressor.EntityValueClient client) {
        return new LongValuesIndexProgressor(this.getMatchingDocs(), this.getTotalHits(), field, (arg_0, arg_1, arg_2) -> ((IndexProgressor.EntityValueClient)client).acceptEntity(arg_0, arg_1, arg_2));
    }

    public IndexProgressor getIndexProgressor(String field, EntityConsumer entityConsumer) {
        return new LongValuesIndexProgressor(this.getMatchingDocs(), this.getTotalHits(), field, entityConsumer);
    }

    public ValuesIterator getValuesSortedByRelevance(String field) throws IOException {
        int size = this.getTotalHits();
        if (size == 0) {
            return ValuesIterator.EMPTY;
        }
        TopDocs topDocs = this.getTopDocsByRelevance(size);
        LeafReaderContext[] contexts = DocValuesCollector.getLeafReaderContexts(this.getMatchingDocs());
        return new TopDocsValuesIterator(topDocs, contexts, field);
    }

    int getTotalHits() {
        return this.totalHits;
    }

    private boolean isKeepScores() {
        return this.keepScores;
    }

    public final void collect(int doc) throws IOException {
        this.docs.addDoc(doc);
        if (this.keepScores) {
            if (this.segmentHits >= this.scores.length) {
                float[] newScores = new float[ArrayUtil.oversize((int)(this.segmentHits + 1), (int)4)];
                System.arraycopy(this.scores, 0, newScores, 0, this.segmentHits);
                this.scores = newScores;
            }
            this.scores[this.segmentHits] = this.scorer.score();
        }
        ++this.segmentHits;
        ++this.totalHits;
    }

    public ScoreMode scoreMode() {
        return this.keepScores ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    public void setScorer(Scorable scorer) {
        this.scorer = scorer;
    }

    public void doSetNextReader(LeafReaderContext context) throws IOException {
        if (this.docs != null && this.segmentHits > 0) {
            this.createMatchingDocs();
        }
        int maxDoc = context.reader().maxDoc();
        this.docs = DocValuesCollector.createDocs(maxDoc);
        if (this.keepScores) {
            int initialSize = Math.min(32, maxDoc);
            this.scores = new float[initialSize];
        }
        this.segmentHits = 0;
        this.context = context;
    }

    @VisibleForTesting
    List<MatchingDocs> getMatchingDocs() {
        if (this.docs != null && this.segmentHits > 0) {
            try {
                this.createMatchingDocs();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                this.docs = null;
                this.scores = null;
                this.context = null;
            }
        }
        return this.matchingDocs;
    }

    private static Docs createDocs(int maxDoc) {
        return new Docs(maxDoc);
    }

    private void createMatchingDocs() throws IOException {
        if (this.scores == null || this.scores.length == this.segmentHits) {
            this.matchingDocs.add(new MatchingDocs(this.context, this.docs.getDocIdSet(), this.segmentHits, this.scores));
        } else {
            float[] finalScores = new float[this.segmentHits];
            System.arraycopy(this.scores, 0, finalScores, 0, this.segmentHits);
            this.matchingDocs.add(new MatchingDocs(this.context, this.docs.getDocIdSet(), this.segmentHits, finalScores));
        }
    }

    private TopDocs getTopDocsByRelevance(int size) throws IOException {
        TopScoreDocCollector collector = TopScoreDocCollector.create((int)size, (int)size);
        this.replayTo((Collector)collector);
        return collector.topDocs();
    }

    private static LeafReaderContext[] getLeafReaderContexts(List<MatchingDocs> matchingDocs) {
        int segments = matchingDocs.size();
        LeafReaderContext[] contexts = new LeafReaderContext[segments];
        for (int i = 0; i < segments; ++i) {
            MatchingDocs matchingDoc = matchingDocs.get(i);
            contexts[i] = matchingDoc.context;
        }
        return contexts;
    }

    private void replayTo(Collector collector) throws IOException {
        for (MatchingDocs docs : this.getMatchingDocs()) {
            int doc;
            LeafCollector leafCollector = collector.getLeafCollector(docs.context);
            DocIdSetIterator idIterator = docs.docIdSet;
            Weight weight = new Weight(null){

                public Explanation explain(LeafReaderContext context, int doc) {
                    return null;
                }

                public Scorer scorer(LeafReaderContext context) {
                    return null;
                }

                public boolean isCacheable(LeafReaderContext ctx) {
                    return false;
                }
            };
            ReplayingScorer scorer = this.isKeepScores() ? new ReplayingScorer(weight, docs.scores) : new ConstantScoreScorer(weight, Float.NaN, this.scoreMode(), idIterator);
            leafCollector.setScorer((Scorable)scorer);
            while ((doc = idIterator.nextDoc()) != Integer.MAX_VALUE) {
                leafCollector.collect(doc);
            }
        }
    }

    private static class LongValuesIndexProgressor
    extends LongValuesSource
    implements IndexProgressor {
        private final EntityConsumer entityConsumer;

        LongValuesIndexProgressor(Iterable<MatchingDocs> allMatchingDocs, int totalHits, String field, EntityConsumer entityConsumer) {
            super(allMatchingDocs, totalHits, field);
            this.entityConsumer = entityConsumer;
        }

        public boolean next() {
            while (this.fetchNextEntityId()) {
                if (!this.entityConsumer.acceptEntity(this.next, this.score, null)) continue;
                return true;
            }
            return false;
        }

        public void close() {
        }
    }

    @FunctionalInterface
    public static interface EntityConsumer {
        public boolean acceptEntity(long var1, float var3, Value ... var4);
    }

    private static final class TopDocsValuesIterator
    extends ValuesIterator.Adapter {
        private final ScoreDocsIterator scoreDocs;
        private final String field;
        private final Map<LeafReaderContext, NumericDocValues> docValuesCache;
        private long currentValue;

        TopDocsValuesIterator(TopDocs docs, LeafReaderContext[] contexts, String field) {
            super(Math.toIntExact(docs.totalHits.value));
            if (docs.totalHits.relation != TotalHits.Relation.EQUAL_TO) {
                throw new RuntimeException("Expected total hits value to be exact (EQUAL_TO), but it was: " + docs.totalHits.relation);
            }
            this.field = field;
            this.docValuesCache = new HashMap<LeafReaderContext, NumericDocValues>(contexts.length);
            this.scoreDocs = new ScoreDocsIterator(docs, contexts){

                @Override
                protected void onNextDoc(int localDocID, LeafReaderContext context) {
                    this.loadNextValue(context, localDocID);
                }
            };
        }

        protected boolean fetchNext() {
            if (this.scoreDocs.hasNext()) {
                this.scoreDocs.next();
                ++this.index;
                return this.currentValue != -1L && this.next(this.currentValue);
            }
            return false;
        }

        @Override
        public long current() {
            return this.currentValue;
        }

        @Override
        public float currentScore() {
            return this.scoreDocs.getCurrentDoc().score;
        }

        private void loadNextValue(LeafReaderContext context, int docID) {
            NumericDocValues docValues;
            if (this.docValuesCache.containsKey(context)) {
                docValues = this.docValuesCache.get(context);
            } else {
                try {
                    docValues = context.reader().getNumericDocValues(this.field);
                    this.docValuesCache.put(context, docValues);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (docValues != null) {
                try {
                    int valueDocId = docValues.advance(docID);
                    if (valueDocId != docID) {
                        throw new RuntimeException("Expected doc values and doc scores to iterate together, but score doc id is " + docID + ", and value doc id is " + valueDocId + ".");
                    }
                    this.currentValue = docValues.longValue();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                this.currentValue = -1L;
            }
        }
    }

    private static final class Docs {
        private final DocIdSetBuilder bits;

        Docs(int maxDoc) {
            this.bits = new DocIdSetBuilder(maxDoc);
        }

        private void addDoc(int docId) {
            this.bits.grow(1).add(docId);
        }

        private DocIdSetIterator getDocIdSet() throws IOException {
            return this.bits.build().iterator();
        }
    }

    static final class MatchingDocs {
        public final LeafReaderContext context;
        final DocIdSetIterator docIdSet;
        final float[] scores;
        final int totalHits;

        MatchingDocs(LeafReaderContext context, DocIdSetIterator docIdSet, int totalHits, float[] scores) {
            this.context = context;
            this.docIdSet = docIdSet;
            this.totalHits = totalHits;
            this.scores = scores;
        }

        private NumericDocValues readDocValues(String field) {
            try {
                NumericDocValues dv = this.context.reader().getNumericDocValues(field);
                if (dv == null) {
                    FieldInfo fi = this.context.reader().getFieldInfos().fieldInfo(field);
                    DocValuesType actual = null;
                    if (fi != null) {
                        actual = fi.getDocValuesType();
                    }
                    throw new IllegalStateException("The field '" + field + "' is not indexed properly, expected NumericDV, but got '" + actual + "'");
                }
                return dv;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class ReplayingScorer
    extends Scorer {
        private final float[] scores;
        private int index;

        ReplayingScorer(Weight weight, float[] scores) {
            super(weight);
            this.scores = scores;
        }

        public float score() {
            if (this.index < this.scores.length) {
                return this.scores[this.index++];
            }
            return Float.NaN;
        }

        public DocIdSetIterator iterator() {
            throw new UnsupportedOperationException();
        }

        public float getMaxScore(int upTo) {
            throw new UnsupportedOperationException();
        }

        public int docID() {
            throw new UnsupportedOperationException();
        }
    }

    private static abstract class ScoreDocsIterator
    extends PrefetchingIterator<ScoreDoc> {
        private final Iterator<ScoreDoc> iterator;
        private final int[] docStarts;
        private final LeafReaderContext[] contexts;
        private ScoreDoc currentDoc;

        private ScoreDocsIterator(TopDocs docs, LeafReaderContext[] contexts) {
            this.contexts = contexts;
            this.iterator = new ArrayIterator((Object[])docs.scoreDocs);
            int segments = contexts.length;
            this.docStarts = new int[segments + 1];
            for (int i = 0; i < segments; ++i) {
                LeafReaderContext context = contexts[i];
                this.docStarts[i] = context.docBase;
            }
            LeafReaderContext lastContext = contexts[segments - 1];
            this.docStarts[segments] = lastContext.docBase + lastContext.reader().maxDoc();
        }

        private ScoreDoc getCurrentDoc() {
            return this.currentDoc;
        }

        protected ScoreDoc fetchNextOrNull() {
            if (!this.iterator.hasNext()) {
                return null;
            }
            this.currentDoc = this.iterator.next();
            int subIndex = ReaderUtil.subIndex((int)this.currentDoc.doc, (int[])this.docStarts);
            LeafReaderContext context = this.contexts[subIndex];
            this.onNextDoc(this.currentDoc.doc - context.docBase, context);
            return this.currentDoc;
        }

        protected abstract void onNextDoc(int var1, LeafReaderContext var2);
    }

    private static abstract class LongValuesSource {
        private final Iterator<MatchingDocs> matchingDocs;
        private final String field;
        final int totalHits;
        DocIdSetIterator currentIdIterator;
        NumericDocValues currentDocValues;
        MatchingDocs currentDocs;
        float score;
        int index;
        long next;

        LongValuesSource(Iterable<MatchingDocs> allMatchingDocs, int totalHits, String field) {
            this.totalHits = totalHits;
            this.field = field;
            this.matchingDocs = allMatchingDocs.iterator();
            this.score = Float.NaN;
        }

        boolean ensureValidDisi() {
            while (this.currentIdIterator == null) {
                if (this.matchingDocs.hasNext()) {
                    this.currentDocs = this.matchingDocs.next();
                    this.currentIdIterator = this.currentDocs.docIdSet;
                    this.index = 0;
                    if (this.currentIdIterator == null) continue;
                    this.currentDocValues = this.currentDocs.readDocValues(this.field);
                    continue;
                }
                return false;
            }
            return true;
        }

        boolean fetchNextEntityId() {
            try {
                if (this.ensureValidDisi()) {
                    int nextDoc = this.currentIdIterator.nextDoc();
                    if (nextDoc != Integer.MAX_VALUE) {
                        if (this.currentDocs.scores != null) {
                            this.score = this.currentDocs.scores[this.index];
                        }
                        ++this.index;
                        int valueDoc = this.currentDocValues.advance(nextDoc);
                        if (valueDoc != nextDoc) {
                            throw new RuntimeException("Document id and document value iterators are out of sync. Id iterator gave me document " + nextDoc + ", while the value iterator gave me document " + valueDoc + ".");
                        }
                        this.next = this.currentDocValues.longValue();
                        return true;
                    }
                    this.currentIdIterator = null;
                    return this.fetchNextEntityId();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return false;
        }
    }
}

