/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.storage;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.NRTCachingDirectory;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.util.FeatureToggles;

public interface DirectoryFactory
extends AutoCloseable {
    public static final DirectoryFactory PERSISTENT = new DirectoryFactory(){
        private final int MAX_MERGE_SIZE_MB = FeatureToggles.getInteger(DirectoryFactory.class, (String)"max_merge_size_mb", (int)5);
        private final int MAX_CACHED_MB = FeatureToggles.getInteger(DirectoryFactory.class, (String)"max_cached_mb", (int)50);
        private final boolean USE_DEFAULT_DIRECTORY_FACTORY = FeatureToggles.flag(DirectoryFactory.class, (String)"default_directory_factory", (boolean)true);

        @Override
        public Directory open(Path dir) throws IOException {
            Files.createDirectories(dir, new FileAttribute[0]);
            FSDirectory directory = this.USE_DEFAULT_DIRECTORY_FACTORY ? FSDirectory.open((Path)dir) : new NIOFSDirectory(dir);
            return new NRTCachingDirectory((Directory)directory, (double)this.MAX_MERGE_SIZE_MB, (double)this.MAX_CACHED_MB);
        }

        @Override
        public void close() {
        }
    };

    public static DirectoryFactory directoryFactory(FileSystemAbstraction fs) {
        return fs.isPersistent() ? PERSISTENT : new InMemoryDirectoryFactory();
    }

    public Directory open(Path var1) throws IOException;

    public static final class InMemoryDirectoryFactory
    implements DirectoryFactory {
        private final Map<Path, Directory> directories = new HashMap<Path, Directory>();

        @Override
        public synchronized Directory open(Path dir) {
            if (!this.directories.containsKey(dir)) {
                this.directories.put(dir, (Directory)new ByteBuffersDirectory());
            }
            return new UncloseableDirectory(this.directories.get(dir));
        }

        @Override
        public synchronized void close() throws IOException {
            IOUtils.closeAll(this.directories.values());
            this.directories.clear();
        }
    }

    public static final class UncloseableDirectory
    extends FilterDirectory {
        public UncloseableDirectory(Directory delegate) {
            super(delegate);
        }

        public void close() {
        }
    }

    public static final class Single
    implements DirectoryFactory {
        private final Directory directory;

        public Single(Directory directory) {
            this.directory = directory;
        }

        @Override
        public Directory open(Path dir) {
            return this.directory;
        }

        @Override
        public void close() {
        }
    }
}

