/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.vector;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.neo4j.internal.helpers.collection.BoundedIterable;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexQuery;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.impl.index.SearcherReference;
import org.neo4j.kernel.api.impl.index.collector.ScoredEntityIterator;
import org.neo4j.kernel.api.impl.index.collector.ValuesIterator;
import org.neo4j.kernel.api.impl.schema.AbstractLuceneIndexReader;
import org.neo4j.kernel.api.impl.schema.LuceneScoredEntityIndexProgressor;
import org.neo4j.kernel.api.impl.schema.reader.IndexReaderCloseException;
import org.neo4j.kernel.api.impl.schema.vector.VectorQueryFactory;
import org.neo4j.kernel.api.impl.schema.vector.VectorResultCollector;
import org.neo4j.kernel.api.impl.schema.vector.VectorUtils;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexSampler;
import org.neo4j.kernel.impl.index.schema.IndexUsageTracker;
import org.neo4j.values.storable.Value;

class VectorIndexReader
extends AbstractLuceneIndexReader {
    private final List<SearcherReference> searchers;
    private final int vectorDimensionality;

    VectorIndexReader(IndexDescriptor descriptor, List<SearcherReference> searchers, IndexUsageTracker usageTracker) {
        super(descriptor, usageTracker);
        this.searchers = searchers;
        this.vectorDimensionality = VectorUtils.vectorDimensionsFrom(descriptor.getIndexConfig());
    }

    public long countIndexedEntities(long entityId, CursorContext cursorContext, int[] propertyKeyIds, Value ... propertyValues) {
        long count = 0L;
        Query query = VectorQueryFactory.getById(entityId);
        for (SearcherReference searcher : this.searchers) {
            try {
                count += (long)searcher.getIndexSearcher().count(query);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return count;
    }

    public IndexSampler createSampler() {
        return IndexSampler.EMPTY;
    }

    @Override
    public void query(IndexProgressor.EntityValueClient client, QueryContext context, AccessMode accessMode, IndexQueryConstraints constraints, PropertyIndexQuery ... predicates) throws IndexNotApplicableKernelException {
        super.query(client, context, accessMode, this.adjustedConstraints(constraints, predicates), predicates);
    }

    @Override
    protected PropertyIndexQuery validateQuery(PropertyIndexQuery ... predicates) throws IndexNotApplicableKernelException {
        PropertyIndexQuery.NearestNeighborsPredicate nearestNeighbour;
        float[] queryVector;
        PropertyIndexQuery predicate = super.validateQuery(predicates);
        if (predicate instanceof PropertyIndexQuery.NearestNeighborsPredicate && (queryVector = (nearestNeighbour = (PropertyIndexQuery.NearestNeighborsPredicate)predicate).query()).length != this.vectorDimensionality) {
            throw new IndexNotApplicableKernelException("Index query vector has a dimensionality of %d, but indexed vectors have %d.".formatted(queryVector.length, this.vectorDimensionality));
        }
        return predicate;
    }

    private IndexQueryConstraints adjustedConstraints(IndexQueryConstraints constraints, PropertyIndexQuery ... predicates) throws IndexNotApplicableKernelException {
        IndexQueryConstraints indexQueryConstraints;
        PropertyIndexQuery propertyIndexQuery = this.validateQuery(predicates);
        if (propertyIndexQuery instanceof PropertyIndexQuery.NearestNeighborsPredicate) {
            PropertyIndexQuery.NearestNeighborsPredicate nearestNeighbour = (PropertyIndexQuery.NearestNeighborsPredicate)propertyIndexQuery;
            indexQueryConstraints = constraints.limit(Math.min((long)nearestNeighbour.numberOfNeighbors(), constraints.limit().orElse(Integer.MAX_VALUE)));
        } else {
            indexQueryConstraints = constraints;
        }
        return indexQueryConstraints;
    }

    @Override
    protected Query toLuceneQuery(PropertyIndexQuery predicate, IndexQueryConstraints constraints) {
        return switch (predicate.type()) {
            case IndexQuery.IndexQueryType.ALL_ENTRIES -> VectorQueryFactory.allValues();
            case IndexQuery.IndexQueryType.NEAREST_NEIGHBORS -> {
                PropertyIndexQuery.NearestNeighborsPredicate nearestNeighborsPredicate = (PropertyIndexQuery.NearestNeighborsPredicate)predicate;
                long k = Math.min((long)nearestNeighborsPredicate.numberOfNeighbors(), constraints.limit().orElse(Integer.MAX_VALUE));
                long effectiveK = k + constraints.skip().orElse(0L);
                yield VectorQueryFactory.approximateNearestNeighbors(nearestNeighborsPredicate.query(), Math.toIntExact(effectiveK));
            }
            default -> throw this.invalidQuery(IllegalArgumentException::new, predicate);
        };
    }

    @Override
    protected IndexProgressor indexProgressor(Query query, IndexQueryConstraints constraints, IndexProgressor.EntityValueClient client) {
        ValuesIterator iterator = this.searchLucene(query, constraints);
        return new LuceneScoredEntityIndexProgressor(iterator, client, constraints);
    }

    @Override
    protected String entityIdFieldKey() {
        return "id";
    }

    @Override
    protected boolean needStoreFilter(PropertyIndexQuery predicate) {
        return false;
    }

    @Override
    public void close() {
        new IOUtils.AutoCloseables(IndexReaderCloseException::new, this.searchers).close();
    }

    private ValuesIterator searchLucene(Query query, IndexQueryConstraints constraints) {
        try {
            ArrayList<ValuesIterator> results = new ArrayList<ValuesIterator>(this.searchers.size());
            for (SearcherReference searcher : this.searchers) {
                VectorResultCollector collector = new VectorResultCollector(constraints);
                searcher.getIndexSearcher().search(query, collector);
                results.add(collector.iterator());
            }
            return ScoredEntityIterator.mergeIterators(results);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    BoundedIterable<Long> newAllEntriesValueReader(long fromIdInclusive, long toIdExclusive) throws IOException {
        String field = "id";
        MatchAllDocsQuery query = VectorQueryFactory.allValues();
        ArrayList<BoundedIterable<Long>> iterables = new ArrayList<BoundedIterable<Long>>(this.searchers.size());
        for (SearcherReference searcher : this.searchers) {
            iterables.add(this.newAllEntriesValueReaderForPartition("id", searcher.getIndexSearcher(), (Query)query, fromIdInclusive, toIdExclusive));
        }
        return BoundedIterable.concat(iterables);
    }
}

