/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.vector;

import org.neo4j.internal.schema.IndexBehaviour;
import org.neo4j.internal.schema.IndexCapability;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexQuery;
import org.neo4j.kernel.api.impl.schema.vector.VectorSimilarityFunction;
import org.neo4j.kernel.api.impl.schema.vector.VectorUtils;
import org.neo4j.util.Preconditions;
import org.neo4j.values.storable.FloatingPointArray;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueCategory;

class VectorIndexCapability
implements IndexCapability {
    private final int dimensions;
    private final VectorSimilarityFunction similarityFunction;

    VectorIndexCapability(IndexConfig config) {
        this.dimensions = VectorUtils.vectorDimensionsFrom(config);
        this.similarityFunction = VectorUtils.vectorSimilarityFunctionFrom(config);
    }

    public boolean supportsOrdering() {
        return false;
    }

    public boolean supportsReturningValues() {
        return false;
    }

    public boolean areValuesAccepted(Value ... values) {
        FloatingPointArray array;
        Value value;
        Preconditions.requireNonEmpty((Object[])values);
        Preconditions.requireNoNullElements((Object[])values);
        return values.length == 1 && (value = values[0]) instanceof FloatingPointArray && (array = (FloatingPointArray)value).length() == this.dimensions && this.similarityFunction.maybeToValidVector(array) != null;
    }

    public boolean areValueCategoriesAccepted(ValueCategory ... valueCategories) {
        Preconditions.requireNonEmpty((Object[])valueCategories);
        Preconditions.requireNoNullElements((Object[])valueCategories);
        return valueCategories.length == 1 && valueCategories[0] == ValueCategory.NUMBER_ARRAY;
    }

    public boolean isQuerySupported(IndexQuery.IndexQueryType queryType, ValueCategory valueCategory) {
        if (queryType == IndexQuery.IndexQueryType.ALL_ENTRIES) {
            return true;
        }
        if (!this.areValueCategoriesAccepted(valueCategory)) {
            return false;
        }
        return queryType == IndexQuery.IndexQueryType.NEAREST_NEIGHBORS;
    }

    public double getCostMultiplier(IndexQuery.IndexQueryType ... queryTypes) {
        return 1.0;
    }

    public boolean supportPartitionedScan(IndexQuery ... queries) {
        Preconditions.requireNonEmpty((Object[])queries);
        Preconditions.requireNoNullElements((Object[])queries);
        return false;
    }

    public IndexBehaviour[] behaviours() {
        return BEHAVIOURS_NONE;
    }
}

