/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.vector;

import java.util.function.Supplier;
import org.apache.lucene.index.IndexWriterConfig;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.impl.index.DatabaseIndex;
import org.neo4j.kernel.api.impl.index.IndexWriterConfigs;
import org.neo4j.kernel.api.impl.index.WritableDatabaseIndex;
import org.neo4j.kernel.api.impl.index.builder.AbstractLuceneIndexBuilder;
import org.neo4j.kernel.api.impl.index.partition.WritableIndexPartitionFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.kernel.api.impl.schema.LuceneIndexType;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndex;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexReader;

class VectorIndexBuilder
extends AbstractLuceneIndexBuilder<VectorIndexBuilder> {
    private final IndexDescriptor descriptor;
    private final Config config;
    private Supplier<IndexWriterConfig> writerConfigFactory;

    private VectorIndexBuilder(IndexDescriptor descriptor, DatabaseReadOnlyChecker readOnlyChecker, Config config) {
        super(readOnlyChecker);
        this.descriptor = descriptor;
        this.config = config;
        this.writerConfigFactory = () -> IndexWriterConfigs.standard(LuceneIndexType.VECTOR, config, descriptor.getIndexConfig());
    }

    static VectorIndexBuilder create(IndexDescriptor descriptor, DatabaseReadOnlyChecker readOnlyChecker, Config config) {
        return new VectorIndexBuilder(descriptor, readOnlyChecker, config);
    }

    VectorIndexBuilder withWriterConfig(Supplier<IndexWriterConfig> writerConfigFactory) {
        this.writerConfigFactory = writerConfigFactory;
        return this;
    }

    DatabaseIndex<VectorIndexReader> build() {
        PartitionedIndexStorage storage = this.storageBuilder.build();
        VectorIndex index = new VectorIndex(storage, new WritableIndexPartitionFactory(this.writerConfigFactory), this.descriptor, this.config);
        return new WritableDatabaseIndex(index, this.readOnlyChecker, this.permanentlyReadOnly);
    }
}

