/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.vector;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.KnnFloatVectorField;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.neo4j.kernel.api.impl.schema.vector.VectorSimilarityFunction;
import org.neo4j.values.storable.FloatingPointArray;

class VectorDocumentStructure {
    static final String ENTITY_ID_KEY = "id";
    static final String VECTOR_VALUE_KEY = "vector";

    VectorDocumentStructure() {
    }

    static Term newTermForChangeOrRemove(long id) {
        return new Term(ENTITY_ID_KEY, Long.toString(id));
    }

    static Document createLuceneDocument(long id, FloatingPointArray value, VectorSimilarityFunction similarityFunction) {
        float[] vector = similarityFunction.maybeToValidVector(value);
        if (vector == null) {
            return null;
        }
        Document document = new Document();
        StringField idField = new StringField(ENTITY_ID_KEY, Long.toString(id), Field.Store.NO);
        NumericDocValuesField idValueField = new NumericDocValuesField(ENTITY_ID_KEY, id);
        KnnFloatVectorField valueField = new KnnFloatVectorField(VECTOR_VALUE_KEY, vector, similarityFunction.toLucene());
        document.add((IndexableField)idField);
        document.add((IndexableField)idValueField);
        document.add((IndexableField)valueField);
        return document;
    }
}

