/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.vector;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.schema.vector.VectorDocumentStructure;
import org.neo4j.kernel.api.impl.schema.vector.VectorSimilarityFunction;
import org.neo4j.kernel.api.impl.schema.writer.LuceneIndexWriter;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.index.schema.IndexUpdateIgnoreStrategy;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.UpdateMode;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.values.storable.FloatingPointArray;
import org.neo4j.values.storable.Value;

class VectorIndexPopulatingUpdater
implements IndexUpdater {
    private final LuceneIndexWriter writer;
    private final IndexUpdateIgnoreStrategy ignoreStrategy;
    private final VectorSimilarityFunction similarityFunction;

    VectorIndexPopulatingUpdater(LuceneIndexWriter writer, IndexUpdateIgnoreStrategy ignoreStrategy, VectorSimilarityFunction similarityFunction) {
        this.writer = writer;
        this.ignoreStrategy = ignoreStrategy;
        this.similarityFunction = similarityFunction;
    }

    public void process(IndexEntryUpdate<?> update) {
        ValueIndexEntryUpdate<?> valueUpdate = this.asValueUpdate(update);
        if (valueUpdate == null) {
            return;
        }
        try {
            long entityId = valueUpdate.getEntityId();
            Value[] values = valueUpdate.values();
            FloatingPointArray value = (FloatingPointArray)values[0];
            UpdateMode updateMode = valueUpdate.updateMode();
            switch (updateMode) {
                case ADDED: {
                    this.writer.updateDocument(VectorDocumentStructure.newTermForChangeOrRemove(entityId), VectorDocumentStructure.createLuceneDocument(entityId, value, this.similarityFunction));
                    break;
                }
                case CHANGED: {
                    this.writer.updateOrDeleteDocument(VectorDocumentStructure.newTermForChangeOrRemove(entityId), VectorDocumentStructure.createLuceneDocument(entityId, value, this.similarityFunction));
                    break;
                }
                case REMOVED: {
                    this.writer.deleteDocuments(VectorDocumentStructure.newTermForChangeOrRemove(entityId));
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public <INDEX_KEY extends SchemaDescriptorSupplier> ValueIndexEntryUpdate<INDEX_KEY> asValueUpdate(IndexEntryUpdate<INDEX_KEY> update) {
        ValueIndexEntryUpdate valueUpdate = super.asValueUpdate(update);
        return !this.ignoreStrategy.ignore(valueUpdate) ? this.ignoreStrategy.toEquivalentUpdate(valueUpdate) : null;
    }

    public void close() throws IndexEntryConflictException {
    }
}

