/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.vector;

import org.neo4j.graphdb.schema.IndexSetting;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.kernel.api.impl.schema.vector.VectorSimilarityFunction;
import org.neo4j.values.AnyValue;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.storable.FloatingPointArray;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class VectorUtils {
    public static final int MAX_DIMENSIONS = 2048;

    public static int vectorDimensionsFrom(IndexConfig config) {
        IndexSetting setting = IndexSetting.vector_Dimensions();
        int dimensions = ((IntegralValue)VectorUtils.getExpectedFrom(config, setting)).intValue();
        if (dimensions <= 0) {
            throw new IllegalArgumentException("Invalid %s provided.".formatted(IndexConfig.class.getSimpleName()), (Throwable)((Object)new AssertionError((Object)"'%s' is expected to be positive. Provided: %d".formatted(setting.getSettingName(), dimensions))));
        }
        return dimensions;
    }

    public static VectorSimilarityFunction vectorSimilarityFunctionFrom(IndexConfig config) {
        try {
            return VectorSimilarityFunction.fromName(((TextValue)VectorUtils.getExpectedFrom(config, IndexSetting.vector_Similarity_Function())).stringValue());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid %s provided.".formatted(IndexConfig.class.getSimpleName()), e);
        }
    }

    private static <T extends Value> T getExpectedFrom(IndexConfig config, IndexSetting setting) {
        String name = setting.getSettingName();
        return (T)config.getOrThrow(name, () -> new IllegalArgumentException("Invalid %s provided.".formatted(IndexConfig.class.getSimpleName()), (Throwable)((Object)new AssertionError((Object)"'%s' is expected to have been set".formatted(name)))));
    }

    public static FloatingPointArray maybeToFloatingPointArray(AnyValue candidate) {
        if (candidate == null) {
            return null;
        }
        if (candidate instanceof FloatingPointArray) {
            FloatingPointArray floatingPointArray = (FloatingPointArray)candidate;
            return floatingPointArray;
        }
        if (candidate instanceof SequenceValue) {
            SequenceValue list = (SequenceValue)candidate;
            return VectorUtils.maybeToFloatingPointArray(list);
        }
        return null;
    }

    public static FloatingPointArray maybeToFloatingPointArray(SequenceValue candidate) {
        if (candidate == null) {
            return null;
        }
        double[] array = new double[candidate.length()];
        for (int i = 0; i < array.length; ++i) {
            AnyValue anyValue = candidate.value(i);
            if (!(anyValue instanceof NumberValue)) {
                return null;
            }
            NumberValue number = (NumberValue)anyValue;
            array[i] = number.doubleValue();
        }
        return Values.doubleArray((double[])array);
    }

    private VectorUtils() {
    }
}

