/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.vector;

import org.neo4j.graphdb.schema.IndexSetting;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexVersion;
import org.neo4j.kernel.api.vector.VectorSimilarityFunction;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;

public class VectorUtils {
    public static int vectorDimensionsFrom(IndexConfig config) {
        IndexSetting setting = IndexSetting.vector_Dimensions();
        int dimensions = ((IntegralValue)VectorUtils.getExpectedFrom(config, setting)).intValue();
        if (dimensions <= 0) {
            throw new IllegalArgumentException("Invalid %s provided.".formatted(IndexConfig.class.getSimpleName()), (Throwable)((Object)new AssertionError((Object)"'%s' is expected to be positive. Provided: %d".formatted(setting.getSettingName(), dimensions))));
        }
        return dimensions;
    }

    public static VectorSimilarityFunction vectorSimilarityFunctionFrom(VectorIndexVersion version, IndexConfig config) {
        try {
            return version.similarityFunction(((TextValue)VectorUtils.getExpectedFrom(config, IndexSetting.vector_Similarity_Function())).stringValue());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid %s provided.".formatted(IndexConfig.class.getSimpleName()), e);
        }
    }

    private static <T extends Value> T getExpectedFrom(IndexConfig config, IndexSetting setting) {
        String name = setting.getSettingName();
        return (T)config.getOrThrow(name, () -> new IllegalArgumentException("Invalid %s provided.".formatted(IndexConfig.class.getSimpleName()), (Throwable)((Object)new AssertionError((Object)"'%s' is expected to have been set".formatted(name)))));
    }

    private VectorUtils() {
    }
}

