/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.KeepOnlyLastCommitDeletionPolicy;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.SerialMergeScheduler;
import org.apache.lucene.index.SnapshotDeletionPolicy;
import org.neo4j.configuration.Config;
import org.neo4j.kernel.api.impl.index.LuceneSettings;

public final class IndexWriterConfigs {
    private static final Analyzer KEYWORD_ANALYZER = new KeywordAnalyzer();

    private IndexWriterConfigs() {
        throw new AssertionError((Object)"Not for instantiation!");
    }

    public static IndexWriterConfig standard(Config config) {
        return IndexWriterConfigs.standard(config, KEYWORD_ANALYZER);
    }

    public static IndexWriterConfig standard(Config config, Analyzer analyzer) {
        IndexWriterConfig writerConfig = new IndexWriterConfig(analyzer);
        writerConfig.setMaxBufferedDocs(((Integer)config.get(LuceneSettings.lucene_writer_max_buffered_docs)).intValue());
        writerConfig.setIndexDeletionPolicy((IndexDeletionPolicy)new SnapshotDeletionPolicy((IndexDeletionPolicy)new KeepOnlyLastCommitDeletionPolicy()));
        writerConfig.setUseCompoundFile(true);
        writerConfig.setMaxFullFlushMergeWaitMillis(0L);
        writerConfig.setRAMBufferSizeMB(((Double)config.get(LuceneSettings.lucene_standard_ram_buffer_size)).doubleValue());
        LogByteSizeMergePolicy mergePolicy = new LogByteSizeMergePolicy();
        mergePolicy.setNoCFSRatio(((Double)config.get(LuceneSettings.lucene_nocfs_ratio)).doubleValue());
        mergePolicy.setMinMergeMB(((Double)config.get(LuceneSettings.lucene_min_merge)).doubleValue());
        mergePolicy.setMergeFactor(((Integer)config.get(LuceneSettings.lucene_merge_factor)).intValue());
        writerConfig.setMergePolicy((MergePolicy)mergePolicy);
        return writerConfig;
    }

    public static IndexWriterConfig population(Config config) {
        return IndexWriterConfigs.population(config, KEYWORD_ANALYZER);
    }

    public static IndexWriterConfig population(Config config, Analyzer analyzer) {
        IndexWriterConfig writerConfig = IndexWriterConfigs.standard(config, analyzer);
        writerConfig.setMaxBufferedDocs(((Integer)config.get(LuceneSettings.lucene_population_max_buffered_docs)).intValue());
        writerConfig.setRAMBufferSizeMB(((Double)config.get(LuceneSettings.lucene_population_ram_buffer_size)).doubleValue());
        if (((Boolean)config.get(LuceneSettings.lucene_population_serial_merge_scheduler)).booleanValue()) {
            writerConfig.setMergeScheduler((MergeScheduler)new SerialMergeScheduler());
        }
        return writerConfig;
    }

    public static IndexWriterConfig transactionState(Config config, Analyzer analyzer) {
        IndexWriterConfig writerConfig = IndexWriterConfigs.standard(config, analyzer);
        writerConfig.setCommitOnClose(false);
        return writerConfig;
    }
}

