/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Function;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.neo4j.internal.helpers.collection.BoundedIterable;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.kernel.api.impl.index.collector.DocValuesCollector;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.index.schema.IndexUsageTracking;
import org.neo4j.kernel.impl.index.schema.PartitionedValueSeek;

public abstract class AbstractLuceneIndexReader
implements ValueIndexReader {
    private final IndexDescriptor descriptor;
    private final IndexUsageTracking usageTracker;

    public AbstractLuceneIndexReader(IndexDescriptor descriptor, IndexUsageTracking usageTracker) {
        this.descriptor = descriptor;
        this.usageTracker = usageTracker;
    }

    public void query(IndexProgressor.EntityValueClient client, QueryContext context, IndexQueryConstraints constraints, PropertyIndexQuery ... predicates) throws IndexNotApplicableKernelException {
        PropertyIndexQuery predicate = this.validateQuery(predicates);
        Query query = this.toLuceneQuery(predicate, constraints);
        context.monitor().queried(this.descriptor);
        this.usageTracker.queried();
        IndexProgressor progressor = this.indexProgressor(query, constraints, client);
        boolean needStoreFilter = this.needStoreFilter(predicate);
        client.initializeQuery(this.descriptor, progressor, false, needStoreFilter, constraints, new PropertyIndexQuery[]{predicate});
    }

    protected PropertyIndexQuery validateQuery(PropertyIndexQuery ... predicates) throws IndexNotApplicableKernelException {
        if (predicates.length > 1) {
            throw this.invalidCompositeQuery(IndexNotApplicableKernelException::new, predicates);
        }
        PropertyIndexQuery predicate = predicates[0];
        if (!this.descriptor.getCapability().isQuerySupported(predicate.type(), predicate.valueCategory())) {
            throw this.invalidQuery(IndexNotApplicableKernelException::new, predicate);
        }
        return predicate;
    }

    protected abstract Query toLuceneQuery(PropertyIndexQuery var1, IndexQueryConstraints var2);

    protected <E extends Exception> E invalidCompositeQuery(Function<String, E> constructor, PropertyIndexQuery ... predicates) {
        IndexType indexType = this.descriptor.getIndexType();
        return (E)((Exception)constructor.apply("Tried to query a %s index with a composite query. Composite queries are not supported by a %s index. Query was: %s ".formatted(indexType, indexType, Arrays.toString(predicates))));
    }

    protected <E extends Exception> E invalidQuery(Function<String, E> constructor, PropertyIndexQuery predicate) {
        IndexType indexType = this.descriptor.getIndexType();
        return (E)((Exception)constructor.apply("Index query not supported for %s index. Query: %s".formatted(indexType, predicate)));
    }

    protected abstract IndexProgressor indexProgressor(Query var1, IndexQueryConstraints var2, IndexProgressor.EntityValueClient var3);

    protected abstract String entityIdFieldKey();

    protected abstract boolean needStoreFilter(PropertyIndexQuery var1);

    public PartitionedValueSeek valueSeek(int desiredNumberOfPartitions, QueryContext context, PropertyIndexQuery ... query) {
        throw new UnsupportedOperationException();
    }

    public void close() {
    }

    protected DocValuesCollector search(IndexSearcher searcher, Query query) {
        try {
            DocValuesCollector docValuesCollector = new DocValuesCollector();
            searcher.search(query, (Collector)docValuesCollector);
            return docValuesCollector;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected BoundedIterable<Long> newAllEntriesValueReaderForPartition(String field, IndexSearcher searcher, Query query, long fromIdInclusive, long toIdExclusive) {
        DocValuesCollector collector = this.search(searcher, query);
        DocValuesCollector.InRangeEntityConsumer entityConsumer = new DocValuesCollector.InRangeEntityConsumer(fromIdInclusive, toIdExclusive);
        IndexProgressor indexProgressor = collector.getIndexProgressor(field, entityConsumer);
        return new AllEntriesValueReaderForPartition(indexProgressor, entityConsumer);
    }

    private record AllEntriesValueReaderForPartition(IndexProgressor indexProgressor, DocValuesCollector.InRangeEntityConsumer entityConsumer) implements BoundedIterable<Long>
    {
        public Iterator<Long> iterator() {
            return new PrefetchingIterator<Long>(){

                protected Long fetchNextOrNull() {
                    return indexProgressor.next() ? Long.valueOf(entityConsumer.reference()) : null;
                }
            };
        }

        public long maxCount() {
            return -1L;
        }

        public void close() {
            this.indexProgressor.close();
        }
    }
}

