/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.trigram;

import java.io.IOException;
import java.nio.file.OpenOption;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.internal.schema.AllIndexProviderDescriptors;
import org.neo4j.internal.schema.IndexCapability;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.StorageEngineIndexingBehaviour;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.api.impl.index.DatabaseIndex;
import org.neo4j.kernel.api.impl.index.IndexWriterConfigBuilder;
import org.neo4j.kernel.api.impl.index.IndexWriterConfigModes;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.schema.AbstractTextIndexProvider;
import org.neo4j.kernel.api.impl.schema.TextIndexCapability;
import org.neo4j.kernel.api.impl.schema.trigram.TrigramIndexAccessor;
import org.neo4j.kernel.api.impl.schema.trigram.TrigramIndexBuilder;
import org.neo4j.kernel.api.impl.schema.trigram.TrigramIndexPopulator;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.api.LuceneIndexValueValidator;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.Monitors;

public class TrigramIndexProvider
extends AbstractTextIndexProvider {
    public static final IndexCapability CAPABILITY = TextIndexCapability.trigram();
    private final FileSystemAbstraction fileSystem;

    public TrigramIndexProvider(FileSystemAbstraction fileSystem, DirectoryFactory directoryFactory, IndexDirectoryStructure.Factory directoryStructureFactory, Monitors monitors, Config config, DatabaseReadOnlyChecker readOnlyChecker) {
        super(KernelVersion.VERSION_TRIGRAM_INDEX_INTRODUCED, IndexType.TEXT, AllIndexProviderDescriptors.TEXT_V2_DESCRIPTOR, fileSystem, directoryFactory, directoryStructureFactory, monitors, config, readOnlyChecker);
        this.fileSystem = fileSystem;
    }

    public IndexDescriptor completeConfiguration(IndexDescriptor index, StorageEngineIndexingBehaviour indexingBehaviour) {
        return index.getCapability().equals(IndexCapability.NO_CAPABILITY) ? index.withIndexCapability(CAPABILITY) : index;
    }

    public IndexPopulator getPopulator(IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, ByteBufferFactory bufferFactory, MemoryTracker memoryTracker, TokenNameLookup tokenNameLookup, ImmutableSet<OpenOption> openOptions, StorageEngineIndexingBehaviour indexingBehaviour) {
        IndexWriterConfigBuilder writerConfigBuilder = new IndexWriterConfigBuilder(IndexWriterConfigModes.TextModes.POPULATION, this.config);
        DatabaseIndex<ValueIndexReader> luceneIndex = ((TrigramIndexBuilder)((TrigramIndexBuilder)TrigramIndexBuilder.create(descriptor, this.readOnlyChecker, this.config).withFileSystem(this.fileSystem)).withIndexStorage(this.getIndexStorage(descriptor.getId()))).withWriterConfig(writerConfigBuilder::build).build();
        if (luceneIndex.isReadOnly()) {
            throw new UnsupportedOperationException("Can't create populator for read only index");
        }
        LuceneIndexValueValidator validator = this.valueValidator(descriptor, tokenNameLookup);
        return new TrigramIndexPopulator(luceneIndex, UPDATE_IGNORE_STRATEGY, validator);
    }

    public IndexAccessor getOnlineAccessor(IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, TokenNameLookup tokenNameLookup, ImmutableSet<OpenOption> openOptions, boolean readOnly, StorageEngineIndexingBehaviour indexingBehaviour) throws IOException {
        TrigramIndexBuilder builder = this.builder(descriptor);
        if (readOnly) {
            builder = (TrigramIndexBuilder)builder.permanentlyReadOnly();
        }
        DatabaseIndex<ValueIndexReader> luceneIndex = builder.build();
        luceneIndex.open();
        LuceneIndexValueValidator validator = this.valueValidator(descriptor, tokenNameLookup);
        return new TrigramIndexAccessor(luceneIndex, descriptor, UPDATE_IGNORE_STRATEGY, validator);
    }

    private TrigramIndexBuilder builder(IndexDescriptor descriptor) {
        return (TrigramIndexBuilder)TrigramIndexBuilder.create(descriptor, this.readOnlyChecker, this.config).withIndexStorage(this.getIndexStorage(descriptor.getId()));
    }

    private LuceneIndexValueValidator valueValidator(IndexDescriptor descriptor, TokenNameLookup tokenNameLookup) {
        return new LuceneIndexValueValidator(descriptor, tokenNameLookup);
    }
}

