/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.vector;

import java.io.IOException;
import java.util.List;
import org.neo4j.configuration.Config;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.impl.index.AbstractLuceneIndex;
import org.neo4j.kernel.api.impl.index.SearcherReference;
import org.neo4j.kernel.api.impl.index.partition.AbstractIndexPartition;
import org.neo4j.kernel.api.impl.index.partition.IndexPartitionFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.kernel.api.impl.schema.vector.VectorDocumentStructure;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexConfig;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexReader;
import org.neo4j.kernel.impl.index.schema.IndexUsageTracking;

class VectorIndex
extends AbstractLuceneIndex<VectorIndexReader> {
    private final VectorIndexConfig vectorIndexConfig;
    private final VectorDocumentStructure documentStructure;

    VectorIndex(PartitionedIndexStorage indexStorage, IndexPartitionFactory partitionFactory, VectorDocumentStructure documentStructure, IndexDescriptor descriptor, VectorIndexConfig vectorIndexConfig, Config config) {
        super(indexStorage, partitionFactory, descriptor, config);
        this.vectorIndexConfig = vectorIndexConfig;
        this.documentStructure = documentStructure;
    }

    @Override
    protected VectorIndexReader createSimpleReader(List<AbstractIndexPartition> partitions, IndexUsageTracking usageTracker) throws IOException {
        return this.createPartitionedReader(partitions, usageTracker);
    }

    @Override
    protected VectorIndexReader createPartitionedReader(List<AbstractIndexPartition> partitions, IndexUsageTracking usageTracker) throws IOException {
        List<SearcherReference> searchers = VectorIndex.acquireSearchers(partitions);
        return new VectorIndexReader(this.descriptor, this.vectorIndexConfig, this.documentStructure, searchers, usageTracker);
    }
}

