/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.vector;

import org.neo4j.internal.helpers.MathUtil;
import org.neo4j.kernel.api.vector.VectorCandidate;
import org.neo4j.kernel.api.vector.VectorSimilarityFunction;

public class VectorSimilarityFunctions {
    public static final VectorSimilarityFunction EUCLIDEAN = new LuceneVectorSimilarityFunction(){

        public String name() {
            return "EUCLIDEAN";
        }

        public String toString() {
            return LuceneVectorSimilarityFunction.class.getSimpleName() + ": EUCLIDEAN";
        }

        @Override
        public org.apache.lucene.index.VectorSimilarityFunction toLucene() {
            return org.apache.lucene.index.VectorSimilarityFunction.EUCLIDEAN;
        }

        public float[] maybeToValidVector(VectorCandidate candidate) {
            int dimensions;
            if (candidate == null || (dimensions = candidate.dimensions()) == 0) {
                return null;
            }
            float[] vector = new float[dimensions];
            for (int i = 0; i < dimensions; ++i) {
                float element = candidate.floatElement(i);
                if (!Float.isFinite(element)) {
                    return null;
                }
                vector[i] = element;
            }
            return vector;
        }

        public float[] toValidVector(VectorCandidate candidate) {
            float[] vector = this.maybeToValidVector(candidate);
            if (vector == null) {
                throw new IllegalArgumentException("Vector must only contain finite values. Provided: " + candidate);
            }
            return vector;
        }
    };
    public static final VectorSimilarityFunction SIMPLE_COSINE = new LuceneVectorSimilarityFunction(){

        public String name() {
            return "COSINE";
        }

        public String toString() {
            return LuceneVectorSimilarityFunction.class.getSimpleName() + ": SIMPLE_COSINE";
        }

        @Override
        public org.apache.lucene.index.VectorSimilarityFunction toLucene() {
            return org.apache.lucene.index.VectorSimilarityFunction.COSINE;
        }

        public float[] maybeToValidVector(VectorCandidate candidate) {
            int dimensions;
            if (candidate == null || (dimensions = candidate.dimensions()) == 0) {
                return null;
            }
            float square = 0.0f;
            float[] vector = new float[dimensions];
            for (int i = 0; i < dimensions; ++i) {
                float element = candidate.floatElement(i);
                if (!Float.isFinite(element)) {
                    return null;
                }
                square += element * element;
                vector[i] = element;
            }
            if (square <= 0.0f || !Float.isFinite(square)) {
                return null;
            }
            return vector;
        }

        public float[] toValidVector(VectorCandidate candidate) {
            float[] vector = this.maybeToValidVector(candidate);
            if (vector == null) {
                throw new IllegalArgumentException("Vector must only contain finite values, and have positive and finite l2-norm. Provided: " + candidate);
            }
            return vector;
        }
    };
    public static final VectorSimilarityFunction L2_NORM_COSINE = new LuceneVectorSimilarityFunction(){

        public String name() {
            return "COSINE";
        }

        public String toString() {
            return LuceneVectorSimilarityFunction.class.getSimpleName() + ": L2_NORM_COSINE";
        }

        @Override
        public org.apache.lucene.index.VectorSimilarityFunction toLucene() {
            return org.apache.lucene.index.VectorSimilarityFunction.DOT_PRODUCT;
        }

        public float[] maybeToValidVector(VectorCandidate candidate) {
            double scale;
            int dimensions;
            if (candidate == null || (dimensions = candidate.dimensions()) == 0) {
                return null;
            }
            double square = 0.0;
            for (int i = 0; i < dimensions; ++i) {
                double element = candidate.doubleElement(i);
                if (!Double.isFinite(element)) {
                    return null;
                }
                square += element * element;
            }
            if (square <= 0.0 || !Double.isFinite(square) || !Double.isFinite(scale = 1.0 / Math.sqrt(square))) {
                return null;
            }
            float[] vector = new float[dimensions];
            for (int i = 0; i < dimensions; ++i) {
                float element = (float)(candidate.doubleElement(i) * scale);
                if (!Float.isFinite(element)) {
                    return null;
                }
                vector[i] = element;
            }
            return vector;
        }

        public float[] toValidVector(VectorCandidate candidate) {
            float[] vector = this.maybeToValidVector(candidate);
            if (vector == null) {
                throw new IllegalArgumentException("Vector must only contain finite values, and have positive and finite l2-norm. Provided: " + candidate);
            }
            return vector;
        }
    };

    static abstract class LuceneVectorSimilarityFunction
    implements VectorSimilarityFunction {
        LuceneVectorSimilarityFunction() {
        }

        public float compare(float[] vector1, float[] vector2) {
            return MathUtil.clamp((float)this.toLucene().compare(vector1, vector2), (float)0.0f, (float)1.0f);
        }

        abstract org.apache.lucene.index.VectorSimilarityFunction toLucene();
    }
}

