/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.trigram;

import java.io.IOException;
import java.util.List;
import org.neo4j.configuration.Config;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.impl.index.AbstractLuceneIndex;
import org.neo4j.kernel.api.impl.index.SearcherReference;
import org.neo4j.kernel.api.impl.index.partition.AbstractIndexPartition;
import org.neo4j.kernel.api.impl.index.partition.IndexPartitionFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.kernel.api.impl.schema.reader.PartitionedValueIndexReader;
import org.neo4j.kernel.api.impl.schema.trigram.TrigramIndexReader;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.index.schema.IndexUsageTracking;

class TrigramIndex
extends AbstractLuceneIndex<ValueIndexReader> {
    TrigramIndex(PartitionedIndexStorage indexStorage, IndexDescriptor descriptor, IndexPartitionFactory partitionFactory, Config config) {
        super(indexStorage, partitionFactory, descriptor, config);
    }

    @Override
    protected TrigramIndexReader createSimpleReader(List<AbstractIndexPartition> partitions, IndexUsageTracking usageTracker) throws IOException {
        AbstractIndexPartition searcher = TrigramIndex.getFirstPartition(partitions);
        return new TrigramIndexReader(searcher.acquireSearcher(), this.descriptor, usageTracker);
    }

    @Override
    protected PartitionedValueIndexReader createPartitionedReader(List<AbstractIndexPartition> partitions, IndexUsageTracking usageTracker) throws IOException {
        List<ValueIndexReader> readers = TrigramIndex.acquireSearchers(partitions).stream().map(partitionSearcher -> new TrigramIndexReader((SearcherReference)partitionSearcher, this.descriptor, usageTracker)).toList();
        return new PartitionedValueIndexReader(this.descriptor, readers, usageTracker);
    }
}

