/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.reader;

import java.io.IOException;
import java.util.List;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.impl.index.sampler.AggregatingIndexSampler;
import org.neo4j.kernel.api.impl.schema.reader.IndexReaderCloseException;
import org.neo4j.kernel.api.index.BridgingIndexProgressor;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexSampler;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.index.schema.PartitionedValueSeek;
import org.neo4j.values.storable.Value;

public class PartitionedValueIndexReader
implements ValueIndexReader {
    private final IndexDescriptor descriptor;
    private final List<ValueIndexReader> indexReaders;

    public PartitionedValueIndexReader(IndexDescriptor descriptor, List<ValueIndexReader> readers) {
        this.descriptor = descriptor;
        this.indexReaders = readers;
    }

    public void query(IndexProgressor.EntityValueClient client, QueryContext context, AccessMode accessMode, IndexQueryConstraints constraints, PropertyIndexQuery ... query) throws IndexNotApplicableKernelException {
        try {
            BridgingIndexProgressor bridgingIndexProgressor = new BridgingIndexProgressor(client, this.descriptor.schema().getPropertyIds());
            this.indexReaders.parallelStream().forEach(reader -> {
                try {
                    reader.query((IndexProgressor.EntityValueClient)bridgingIndexProgressor, context, accessMode, constraints, query);
                }
                catch (IndexNotApplicableKernelException e) {
                    throw new InnerException(e);
                }
            });
            boolean needStoreFilter = bridgingIndexProgressor.needStoreFilter();
            client.initialize(this.descriptor, (IndexProgressor)bridgingIndexProgressor, accessMode, false, needStoreFilter, constraints, query);
        }
        catch (InnerException e) {
            throw e.getCause();
        }
    }

    public PartitionedValueSeek valueSeek(int desiredNumberOfPartitions, QueryContext context, PropertyIndexQuery ... query) {
        throw new UnsupportedOperationException();
    }

    public long countIndexedEntities(long entityId, CursorContext cursorContext, int[] propertyKeyIds, Value ... propertyValues) {
        return this.indexReaders.parallelStream().mapToLong(reader -> reader.countIndexedEntities(entityId, cursorContext, propertyKeyIds, propertyValues)).sum();
    }

    public IndexSampler createSampler() {
        List<IndexSampler> indexSamplers = this.indexReaders.parallelStream().map(ValueIndexReader::createSampler).toList();
        return new AggregatingIndexSampler(indexSamplers);
    }

    public void close() {
        try {
            IOUtils.closeAll(this.indexReaders);
        }
        catch (IOException e) {
            throw new IndexReaderCloseException(e);
        }
    }

    private static final class InnerException
    extends RuntimeException {
        private InnerException(IndexNotApplicableKernelException e) {
            super((Throwable)e);
        }

        public synchronized IndexNotApplicableKernelException getCause() {
            return (IndexNotApplicableKernelException)super.getCause();
        }
    }
}

