/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.management;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

class Main {
    private static final String JCONSOLE = "sun.tools.jconsole.JConsole";

    private Main() {
    }

    public static void main(String[] args) throws Throwable {
        Exception failure = null;
        Class<?> jconsole = null;
        try {
            jconsole = Class.forName(JCONSOLE);
        }
        catch (ClassNotFoundException ex) {
            File jar = new File(new File(System.getProperty("java.home"), "lib"), "jconsole.jar");
            if (!jar.exists()) {
                jar = new File(new File(new File(System.getProperty("java.home")).getParentFile(), "lib"), "jconsole.jar");
            }
            ClassLoader loader = null;
            if (jar.exists()) {
                try {
                    loader = new URLClassLoader(new URL[]{jar.toURI().toURL()}, Main.class.getClassLoader());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (loader == null) {
                System.err.println("Could not find jconsole.jar");
                return;
            }
            try {
                jconsole = loader.loadClass(JCONSOLE);
            }
            catch (ClassNotFoundException e) {
                failure = ex;
            }
        }
        Method main = null;
        if (jconsole != null) {
            try {
                main = jconsole.getDeclaredMethod("main", String[].class);
            }
            catch (Exception ex) {
                failure = ex;
            }
        }
        if (main != null) {
            try {
                main.invoke(null, new Object[]{args});
                return;
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
            catch (Exception ex) {
                failure = ex;
            }
        }
        if (failure != null) {
            System.err.println("Failed to launch jconsole: " + failure);
            if (!(failure instanceof ClassNotFoundException)) {
                failure.printStackTrace();
            }
        }
    }
}

