/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.management.impl;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.rmi.ssl.SslRMIServerSocketFactory;
import org.neo4j.kernel.configuration.Settings;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.internal.KernelData;
import org.neo4j.logging.Log;
import org.neo4j.management.impl.AdvancedManagementSupport;
import org.neo4j.management.impl.KernelProxy;

public class HotspotManagementSupport
extends AdvancedManagementSupport {
    protected JMXServiceURL getJMXServiceURL(KernelData kernel) {
        JMXServiceURL url = null;
        Log log = ((LogService)kernel.graphDatabase().getDependencyResolver().resolveDependency(LogService.class)).getInternalLog(HotspotManagementSupport.class);
        try {
            Class<?> cal = Class.forName("sun.management.ConnectorAddressLink");
            try {
                Method importRemoteFrom = cal.getMethod("importRemoteFrom", Integer.TYPE);
                Map remote = (Map)importRemoteFrom.invoke(null, 0);
                url = this.getUrlFrom(remote);
            }
            catch (NoSuchMethodException importRemoteFrom) {
                // empty catch block
            }
            if (url == null) {
                Method importFrom = cal.getMethod("importFrom", Integer.TYPE);
                url = this.getUrlFrom((String)importFrom.invoke(null, 0));
            }
        }
        catch (InvocationTargetException e) {
            log.warn("Failed to load local JMX connection URL.", e.getTargetException());
        }
        catch (Exception | LinkageError e) {
            log.warn("Failed to load local JMX connection URL.", e);
        }
        if (url == null) {
            int port = 0;
            try {
                port = (Integer)kernel.getConfig().get(Settings.setting((String)"jmx.port", (Function)Settings.INTEGER, (String)"0"));
            }
            catch (NumberFormatException importFrom) {
                // empty catch block
            }
            if (port > 0) {
                boolean useSSL = (Boolean)kernel.getConfig().get(Settings.setting((String)"jmx.use_ssl", (Function)Settings.BOOLEAN, (String)"false"));
                log.debug("Creating new MBean server on port %s%s", new Object[]{port, useSSL ? " using ssl" : ""});
                JMXConnectorServer server = this.createServer(port, useSSL, log);
                if (server != null) {
                    try {
                        server.start();
                    }
                    catch (IOException e) {
                        log.warn("Failed to start MBean server", (Throwable)e);
                        server = null;
                    }
                    if (server != null) {
                        try {
                            server.getMBeanServer().registerMBean(server, KernelProxy.createObjectName(kernel.instanceId(), "JMX Server", new String[0]));
                        }
                        catch (Exception e) {
                            log.warn("Failed to register MBean server as JMX bean", (Throwable)e);
                        }
                        url = server.getAddress();
                    }
                }
            }
        }
        return url;
    }

    private JMXServiceURL getUrlFrom(Map<String, String> remote) {
        HashSet<Integer> instances = new HashSet<Integer>();
        for (String string : remote.keySet()) {
            int id;
            int start;
            int end;
            if (!string.startsWith("sun.management.JMXConnectorServer") || (end = string.lastIndexOf(46)) < 0 || (start = string.lastIndexOf(46, end)) < 0) continue;
            try {
                id = Integer.parseInt(string.substring(start, end));
            }
            catch (NumberFormatException e) {
                continue;
            }
            instances.add(id);
        }
        if (!instances.isEmpty()) {
            String prefix = "sun.management.JMXConnectorServer.";
            if (instances.size() > 1) {
                for (Object key : instances.toArray()) {
                    if (remote.containsKey("sun.management.JMXConnectorServer." + key + ".remoteAddress")) continue;
                    instances.remove(key);
                }
                if (instances.contains(0)) {
                    prefix = prefix + "0.";
                }
            }
            if (instances.size() == 1) {
                String string = remote.get(prefix + instances.iterator().next() + "remoteAddress");
                try {
                    return new JMXServiceURL(string);
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }
            if (!instances.isEmpty()) {
                // empty if block
            }
        }
        return null;
    }

    private JMXServiceURL getUrlFrom(String url) {
        JMXServiceURL jmxUrl;
        if (url == null) {
            return null;
        }
        try {
            jmxUrl = new JMXServiceURL(url);
        }
        catch (MalformedURLException e1) {
            return null;
        }
        String host = null;
        try {
            host = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (host == null) {
            host = jmxUrl.getHost();
        }
        try {
            return new JMXServiceURL(jmxUrl.getProtocol(), host, jmxUrl.getPort(), jmxUrl.getURLPath());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private JMXConnectorServer createServer(int port, boolean useSSL, Log log) {
        JMXServiceURL url;
        MBeanServer server = this.getMBeanServer();
        try {
            url = new JMXServiceURL("rmi", null, port);
        }
        catch (MalformedURLException e) {
            log.warn("Failed to start JMX Server", (Throwable)e);
            return null;
        }
        HashMap<String, Object> env = new HashMap<String, Object>();
        if (useSSL) {
            env.put("jmx.remote.rmi.client.socket.factory", new SslRMIClientSocketFactory());
            env.put("jmx.remote.rmi.server.socket.factory", new SslRMIServerSocketFactory());
        }
        try {
            return JMXConnectorServerFactory.newJMXConnectorServer(url, env, server);
        }
        catch (IOException e) {
            log.warn("Failed to start JMX Server", (Throwable)e);
            return null;
        }
    }
}

