/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics;

import com.codahale.metrics.MetricRegistry;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;
import org.neo4j.metrics.MetricsKernelExtensionFactory;
import org.neo4j.metrics.output.CompositeEventReporter;
import org.neo4j.metrics.output.EventReporterBuilder;
import org.neo4j.metrics.source.Neo4jMetricsBuilder;

public class MetricsExtension
implements Lifecycle {
    private final LifeSupport life = new LifeSupport();
    private final MetricsKernelExtensionFactory.Dependencies dependencies;
    private final LogService logService;
    private final Config configuration;
    private final KernelContext kernelContext;

    public MetricsExtension(KernelContext kernelContext, MetricsKernelExtensionFactory.Dependencies dependencies) {
        this.kernelContext = kernelContext;
        this.dependencies = dependencies;
        this.logService = dependencies.logService();
        this.configuration = dependencies.configuration();
    }

    public void init() {
        Log logger = this.logService.getUserLog(this.getClass());
        logger.info("Initiating metrics...");
        MetricRegistry registry = new MetricRegistry();
        CompositeEventReporter reporter = new EventReporterBuilder(this.configuration, registry, logger, this.kernelContext, this.life).build();
        boolean metricsBuilt = new Neo4jMetricsBuilder(registry, reporter, this.configuration, this.logService, this.kernelContext, this.dependencies, this.life).build();
        if (metricsBuilt && reporter.isEmpty()) {
            logger.warn("Several metrics were enabled but no exporting option was configured to report values to. Disabling kernel metrics extension.");
            this.life.clear();
        }
        if (!reporter.isEmpty() && !metricsBuilt) {
            logger.warn("Exporting tool have been configured to report values to but no metrics were enabled. Disabling kernel metrics extension.");
            this.life.clear();
        }
        this.life.init();
    }

    public void start() {
        this.life.start();
    }

    public void stop() {
        this.life.stop();
    }

    public void shutdown() {
        this.life.shutdown();
    }
}

