/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics;

import java.io.File;
import java.util.function.Function;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.Description;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.kernel.configuration.Settings;

@Description(value="Metrics settings")
public class MetricsSettings {
    @Description(value="A common prefix for the reported metrics field names. By default, this is either be 'neo4j', or a computed value based on the cluster and instance names, when running in an HA configuration.")
    public static Setting<String> metricsPrefix = Settings.setting((String)"metrics.prefix", (Function)Settings.STRING, (String)"neo4j");
    @Description(value="The default enablement value for all the supported metrics. Set this to `false` to turn off all metrics by default. The individual settings can then be used to selectively re-enable specific metrics.")
    public static Setting<Boolean> metricsEnabled = Settings.setting((String)"metrics.enabled", (Function)Settings.BOOLEAN, (String)"false");
    @Description(value="The default enablement value for all Neo4j specific support metrics. Set this to `false` to turn off all Neo4j specific metrics by default. The individual `metrics.neo4j.*` metrics can then be turned on selectively.")
    public static Setting<Boolean> neoEnabled = Settings.setting((String)"metrics.neo4j.enabled", (Function)Settings.BOOLEAN, metricsEnabled);
    @Description(value="Enable reporting metrics about transactions; number of transactions started, committed, etc.")
    public static Setting<Boolean> neoTxEnabled = Settings.setting((String)"metrics.neo4j.tx.enabled", (Function)Settings.BOOLEAN, neoEnabled);
    @Description(value="Enable reporting metrics about the Neo4j page cache; page faults, evictions, flushes, exceptions, etc.")
    public static Setting<Boolean> neoPageCacheEnabled = Settings.setting((String)"metrics.neo4j.pagecache.enabled", (Function)Settings.BOOLEAN, neoEnabled);
    @Description(value="Enable reporting metrics about approximately how many entities are in the database; nodes, relationships, properties, etc.")
    public static Setting<Boolean> neoCountsEnabled = Settings.setting((String)"metrics.neo4j.counts.enabled", (Function)Settings.BOOLEAN, neoEnabled);
    @Description(value="Enable reporting metrics about the network usage.")
    public static Setting<Boolean> neoNetworkEnabled = Settings.setting((String)"metrics.neo4j.network.enabled", (Function)Settings.BOOLEAN, neoEnabled);
    @Description(value="Enable reporting metrics about Neo4j check pointing; when it occurs and how much time it takes to complete.")
    public static Setting<Boolean> neoCheckPointingEnabled = Settings.setting((String)"metrics.neo4j.checkpointing.enabled", (Function)Settings.BOOLEAN, neoEnabled);
    @Description(value="Enable reporting metrics about the Neo4j log rotation; when it occurs and how much time it takes to complete.")
    public static Setting<Boolean> neoLogRotationEnabled = Settings.setting((String)"metrics.neo4j.logrotation.enabled", (Function)Settings.BOOLEAN, neoEnabled);
    @Description(value="Enable reporting metrics about HA cluster info.")
    public static Setting<Boolean> neoClusterEnabled = Settings.setting((String)"metrics.neo4j.cluster.enabled", (Function)Settings.BOOLEAN, neoEnabled);
    @Description(value="Enable reporting metrics about Server threading info.")
    public static Setting<Boolean> neoServerEnabled = Settings.setting((String)"metrics.neo4j.server.enabled", (Function)Settings.BOOLEAN, neoEnabled);
    @Description(value="Enable reporting metrics about the duration of garbage collections")
    public static Setting<Boolean> jvmGcEnabled = Settings.setting((String)"metrics.jvm.gc.enabled", (Function)Settings.BOOLEAN, neoEnabled);
    @Description(value="Enable reporting metrics about the memory usage.")
    public static Setting<Boolean> jvmMemoryEnabled = Settings.setting((String)"metrics.jvm.memory.enabled", (Function)Settings.BOOLEAN, neoEnabled);
    @Description(value="Enable reporting metrics about the buffer pools.")
    public static Setting<Boolean> jvmBuffersEnabled = Settings.setting((String)"metrics.jvm.buffers.enabled", (Function)Settings.BOOLEAN, neoEnabled);
    @Description(value="Enable reporting metrics about the current number of threads running.")
    public static Setting<Boolean> jvmThreadsEnabled = Settings.setting((String)"metrics.jvm.threads.enabled", (Function)Settings.BOOLEAN, neoEnabled);
    @Description(value="Enable reporting metrics about number of occurred replanning events.")
    public static Setting<Boolean> cypherPlanningEnabled = Settings.setting((String)"metrics.cypher.replanning.enabled", (Function)Settings.BOOLEAN, neoEnabled);
    @Description(value="Enable reporting metrics about Bolt Protocol message processing.")
    public static Setting<Boolean> boltMessagesEnabled = Settings.setting((String)"metrics.bolt.messages.enabled", (Function)Settings.BOOLEAN, neoEnabled);
    @Description(value="Set to `true` to enable exporting metrics to CSV files")
    public static Setting<Boolean> csvEnabled = Settings.setting((String)"metrics.csv.enabled", (Function)Settings.BOOLEAN, (String)"false");
    @Description(value="The target location of the CSV files: a path to a directory wherein a CSV file per reported field  will be written.")
    public static Setting<File> csvPath = Settings.pathSetting((String)"dbms.directories.metrics", (String)"metrics");
    @Description(value="The reporting interval for the CSV files. That is, how often new rows with numbers are appended to the CSV files.")
    public static Setting<Long> csvInterval = Settings.setting((String)"metrics.csv.interval", (Function)Settings.DURATION, (String)"3s");
    @Description(value="Set to `true` to enable exporting metrics to Graphite.")
    public static Setting<Boolean> graphiteEnabled = Settings.setting((String)"metrics.graphite.enabled", (Function)Settings.BOOLEAN, (String)"false");
    @Description(value="The hostname or IP address of the Graphite server")
    public static Setting<HostnamePort> graphiteServer = Settings.setting((String)"metrics.graphite.server", (Function)Settings.HOSTNAME_PORT, (String)":2003");
    @Description(value="The reporting interval for Graphite. That is, how often to send updated metrics to Graphite.")
    public static Setting<Long> graphiteInterval = Settings.setting((String)"metrics.graphite.interval", (Function)Settings.DURATION, (String)"3s");
}

