/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics.docs;

import java.io.File;
import java.util.List;
import org.neo4j.helpers.Args;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.metrics.docs.MetricsAsciiDocGenerator;

public class GenerateMetricsDocumentation {
    private static final String OUTPUT_FILE_FLAG = "output";

    public static void main(String[] input) throws Exception {
        Args args = Args.withFlags((String[])new String[]{OUTPUT_FILE_FLAG}).parse(input);
        List metricsClassNames = args.orphans();
        if (metricsClassNames.isEmpty()) {
            System.out.println("Usage: GenerateMetricsDocumentation [--output file] className...");
            System.exit(1);
        }
        MetricsAsciiDocGenerator generator = new MetricsAsciiDocGenerator();
        StringBuilder builder = new StringBuilder();
        for (String className : metricsClassNames) {
            generator.generateDocsFor(className, builder);
        }
        String outputFileName = args.get(OUTPUT_FILE_FLAG);
        if (outputFileName != null) {
            File output = new File(outputFileName);
            System.out.println("Saving docs for '" + metricsClassNames + "' in '" + output.getAbsolutePath() + "'.");
            FileUtils.writeToFile((File)output, (String)builder.toString(), (boolean)false);
        } else {
            System.out.println(builder.toString());
        }
    }
}

