/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics.docs;

import java.lang.reflect.Field;
import org.neo4j.kernel.impl.annotations.Documented;

public class MetricsAsciiDocGenerator {
    private static final String NEW_LINE = System.lineSeparator();

    public void generateDocsFor(String metricsResource, StringBuilder builder) {
        Class<?> clazz;
        try {
            clazz = Class.forName(metricsResource);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Couldn't load metrics class: ", e);
        }
        Documented documented = clazz.getAnnotation(Documented.class);
        if (documented == null) {
            throw new IllegalStateException("Missing Documented annotation on the class: " + metricsResource);
        }
        builder.append(documented.value()).append(NEW_LINE).append(NEW_LINE);
        Field[] fields = clazz.getDeclaredFields();
        if (this.existsDocumentedFields(fields)) {
            builder.append("[options=\"header\",cols=\"<1m,<4\"]").append(NEW_LINE);
            builder.append("|===").append(NEW_LINE);
            builder.append("|Name |Description").append(NEW_LINE);
            for (Field field : fields) {
                this.documentField(builder, clazz, field);
            }
            builder.append("|===").append(NEW_LINE);
            builder.append(NEW_LINE);
        }
    }

    private boolean existsDocumentedFields(Field[] fields) {
        for (Field field : fields) {
            if (!field.isAnnotationPresent(Documented.class)) continue;
            return true;
        }
        return false;
    }

    private void documentField(StringBuilder builder, Class clazz, Field field) {
        Documented documented = field.getAnnotation(Documented.class);
        if (documented != null) {
            String name = (String)this.getStaticFieldValue(clazz, field);
            builder.append("|").append(name).append("|").append(documented.value()).append(NEW_LINE);
        }
    }

    private <T> T getStaticFieldValue(Class clazz, Field field) {
        try {
            return (T)field.get(null);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot fetch value of field " + field + " in " + clazz, e);
        }
    }
}

