/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics.source.cluster;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import org.neo4j.com.storecopy.ToNetworkStoreWriter;
import org.neo4j.kernel.ha.MasterClient210;
import org.neo4j.kernel.ha.com.master.MasterServer;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.metrics.source.ByteCountsMetric;

@Documented(value=".Network Metrics")
public class NetworkMetrics
extends LifecycleAdapter {
    private static final String NAME_PREFIX = "neo4j.network";
    @Documented(value="The amount of bytes transmitted on the network containing the transaction data from a slave to the master in order to be committed")
    public static final String SLAVE_NETWORK_TX_WRITES = MetricRegistry.name((String)"neo4j.network", (String[])new String[]{"slave_network_tx_writes"});
    @Documented(value="The amount of bytes transmitted on the network while copying stores from a machines to another")
    public static final String MASTER_NETWORK_STORE_WRITES = MetricRegistry.name((String)"neo4j.network", (String[])new String[]{"master_network_store_writes"});
    @Documented(value="The amount of bytes transmitted on the network containing the transaction data from a master to the slaves in order to propagate committed transactions")
    public static final String MASTER_NETWORK_TX_WRITES = MetricRegistry.name((String)"neo4j.network", (String[])new String[]{"master_network_tx_writes"});
    private final MetricRegistry registry;
    private final Monitors monitors;
    private final ByteCountsMetric masterNetworkTransactionWrites = new ByteCountsMetric();
    private final ByteCountsMetric masterNetworkStoreWrites = new ByteCountsMetric();
    private final ByteCountsMetric slaveNetworkTransactionWrites = new ByteCountsMetric();

    public NetworkMetrics(MetricRegistry registry, Monitors monitors) {
        this.registry = registry;
        this.monitors = monitors;
    }

    public void start() {
        this.monitors.addMonitorListener((Object)this.masterNetworkTransactionWrites, new String[]{MasterServer.class.getName()});
        this.monitors.addMonitorListener((Object)this.masterNetworkStoreWrites, new String[]{ToNetworkStoreWriter.class.getName(), "storeCopier"});
        this.monitors.addMonitorListener((Object)this.slaveNetworkTransactionWrites, new String[]{MasterClient210.class.getName()});
        this.registry.register(MASTER_NETWORK_TX_WRITES, (Metric)((Gauge)this.masterNetworkTransactionWrites::getBytesWritten));
        this.registry.register(MASTER_NETWORK_STORE_WRITES, (Metric)((Gauge)this.masterNetworkStoreWrites::getBytesWritten));
        this.registry.register(SLAVE_NETWORK_TX_WRITES, (Metric)((Gauge)this.slaveNetworkTransactionWrites::getBytesWritten));
    }

    public void stop() {
        this.registry.remove(MASTER_NETWORK_TX_WRITES);
        this.registry.remove(MASTER_NETWORK_STORE_WRITES);
        this.registry.remove(SLAVE_NETWORK_TX_WRITES);
        this.monitors.removeMonitorListener((Object)this.masterNetworkTransactionWrites);
        this.monitors.removeMonitorListener((Object)this.masterNetworkStoreWrites);
        this.monitors.removeMonitorListener((Object)this.slaveNetworkTransactionWrites);
    }
}

