/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics.source.db;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import org.neo4j.cypher.PlanCacheMetricsMonitor;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.Monitors;

@Documented(value=".Cypher Metrics")
public class CypherMetrics
extends LifecycleAdapter {
    private static final String NAME_PREFIX = "neo4j.cypher";
    @Documented(value="The total number of times Cypher has decided to re-plan a query")
    public static final String REPLAN_EVENTS = MetricRegistry.name((String)"neo4j.cypher", (String[])new String[]{"replan_events"});
    private final MetricRegistry registry;
    private final Monitors monitors;
    private final PlanCacheMetricsMonitor cacheMonitor = new PlanCacheMetricsMonitor();

    public CypherMetrics(MetricRegistry registry, Monitors monitors) {
        this.registry = registry;
        this.monitors = monitors;
    }

    public void start() {
        this.monitors.addMonitorListener((Object)this.cacheMonitor, new String[0]);
        this.registry.register(REPLAN_EVENTS, (Metric)((Gauge)() -> ((PlanCacheMetricsMonitor)this.cacheMonitor).numberOfReplans()));
    }

    public void stop() {
        this.registry.remove(REPLAN_EVENTS);
        this.monitors.removeMonitorListener((Object)this.cacheMonitor);
    }
}

