/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics.source.db;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import org.neo4j.io.pagecache.monitoring.PageCacheCounters;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

@Documented(value=".Database PageCache Metrics")
public class PageCacheMetrics
extends LifecycleAdapter {
    private static final String PAGE_CACHE_PREFIX = "neo4j.page_cache";
    @Documented(value="The total number of exceptions seen during the eviction process in the page cache")
    public static final String PC_EVICTION_EXCEPTIONS = MetricRegistry.name((String)"neo4j.page_cache", (String[])new String[]{"eviction_exceptions"});
    @Documented(value="The total number of flushes executed by the page cache")
    public static final String PC_FLUSHES = MetricRegistry.name((String)"neo4j.page_cache", (String[])new String[]{"flushes"});
    @Documented(value="The total number of page unpins executed by the page cache")
    public static final String PC_UNPINS = MetricRegistry.name((String)"neo4j.page_cache", (String[])new String[]{"unpins"});
    @Documented(value="The total number of page pins executed by the page cache")
    public static final String PC_PINS = MetricRegistry.name((String)"neo4j.page_cache", (String[])new String[]{"pins"});
    @Documented(value="The total number of page evictions executed by the page cache")
    public static final String PC_EVICTIONS = MetricRegistry.name((String)"neo4j.page_cache", (String[])new String[]{"evictions"});
    @Documented(value="The total number of page faults happened in the page cache")
    public static final String PC_PAGE_FAULTS = MetricRegistry.name((String)"neo4j.page_cache", (String[])new String[]{"page_faults"});
    private final MetricRegistry registry;
    private final PageCacheCounters pageCacheCounters;

    public PageCacheMetrics(MetricRegistry registry, PageCacheCounters pageCacheCounters) {
        this.registry = registry;
        this.pageCacheCounters = pageCacheCounters;
    }

    public void start() {
        this.registry.register(PC_PAGE_FAULTS, (Metric)((Gauge)() -> ((PageCacheCounters)this.pageCacheCounters).faults()));
        this.registry.register(PC_EVICTIONS, (Metric)((Gauge)() -> ((PageCacheCounters)this.pageCacheCounters).evictions()));
        this.registry.register(PC_PINS, (Metric)((Gauge)() -> ((PageCacheCounters)this.pageCacheCounters).pins()));
        this.registry.register(PC_UNPINS, (Metric)((Gauge)() -> ((PageCacheCounters)this.pageCacheCounters).unpins()));
        this.registry.register(PC_FLUSHES, (Metric)((Gauge)() -> ((PageCacheCounters)this.pageCacheCounters).flushes()));
        this.registry.register(PC_EVICTION_EXCEPTIONS, (Metric)((Gauge)() -> ((PageCacheCounters)this.pageCacheCounters).evictionExceptions()));
    }

    public void stop() {
        this.registry.remove(PC_PAGE_FAULTS);
        this.registry.remove(PC_EVICTIONS);
        this.registry.remove(PC_PINS);
        this.registry.remove(PC_UNPINS);
        this.registry.remove(PC_FLUSHES);
        this.registry.remove(PC_EVICTION_EXCEPTIONS);
    }
}

