/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics;

import com.codahale.metrics.MetricRegistry;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;
import org.neo4j.metrics.MetricsKernelExtensionFactory;
import org.neo4j.metrics.output.CompositeEventReporter;
import org.neo4j.metrics.output.EventReporterBuilder;
import org.neo4j.metrics.source.Neo4jMetricsBuilder;

public class MetricsExtension
implements Lifecycle {
    private final LifeSupport life = new LifeSupport();
    private Log logger;
    private CompositeEventReporter reporter;
    private boolean metricsBuilt;

    MetricsExtension(KernelContext kernelContext, MetricsKernelExtensionFactory.Dependencies dependencies) {
        LogService logService = dependencies.logService();
        Config configuration = dependencies.configuration();
        this.logger = logService.getUserLog(this.getClass());
        MetricRegistry registry = new MetricRegistry();
        this.reporter = new EventReporterBuilder(configuration, registry, this.logger, kernelContext, this.life).build();
        this.metricsBuilt = new Neo4jMetricsBuilder(registry, this.reporter, configuration, logService, kernelContext, dependencies, this.life).build();
    }

    public void init() {
        this.logger.info("Initiating metrics...");
        if (this.metricsBuilt && this.reporter.isEmpty()) {
            this.logger.warn("Several metrics were enabled but no exporting option was configured to report values to. Disabling kernel metrics extension.");
            this.life.clear();
        }
        if (!this.reporter.isEmpty() && !this.metricsBuilt) {
            this.logger.warn("Exporting tool have been configured to report values to but no metrics were enabled. Disabling kernel metrics extension.");
            this.life.clear();
        }
        this.life.init();
    }

    public void start() {
        this.life.start();
    }

    public void stop() {
        this.life.stop();
    }

    public void shutdown() {
        this.life.shutdown();
    }
}

