/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics.source.causalclustering;

import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.neo4j.causalclustering.messaging.monitoring.MessageQueueMonitor;
import org.neo4j.helpers.AdvertisedSocketAddress;

public class MessageQueueMonitorMetric
implements MessageQueueMonitor {
    private Map<String, LongAdder> droppedMessages = new TreeMap<String, LongAdder>();
    private Map<String, AtomicLong> queueSize = new TreeMap<String, AtomicLong>();

    public Long droppedMessages() {
        return this.droppedMessages.values().stream().mapToLong(LongAdder::longValue).sum();
    }

    public void droppedMessage(AdvertisedSocketAddress destination) {
        this.droppedMessages.get(destination.toString()).increment();
    }

    public void queueSize(AdvertisedSocketAddress destination, long size) {
        this.queueSize.get(destination.toString()).set(size);
    }

    public Long queueSizes() {
        return this.queueSize.values().stream().mapToLong(AtomicLong::get).sum();
    }

    public void register(AdvertisedSocketAddress destination) {
        if (!this.droppedMessages.containsKey(destination.toString())) {
            this.droppedMessages.put(destination.toString(), new LongAdder());
        }
        if (!this.queueSize.containsKey(destination.toString())) {
            this.queueSize.put(destination.toString(), new AtomicLong());
        }
    }
}

