/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.monitoring;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.monitoring.ExceptionHandler;

public class ExceptionHandlerService {
    private final List<ExceptionHandler> exceptionHandlers = new CopyOnWriteArrayList<ExceptionHandler>();
    private final InternalLog log;

    public ExceptionHandlerService(InternalLogProvider logProvider) {
        this.log = logProvider.getLog(ExceptionHandlerService.class);
    }

    public void raiseException(String message, Throwable t) {
        try {
            for (ExceptionHandler exceptionHandler : this.exceptionHandlers) {
                try {
                    exceptionHandler.onException(message, t);
                }
                catch (Exception ex) {
                    this.log.error("Error raised during error handling", (Throwable)ex);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandlers.add(exceptionHandler);
    }

    public void removeExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandlers.remove(exceptionHandler);
    }
}

