/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.monitoring;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.impl.bag.mutable.MultiReaderHashBag;
import org.neo4j.internal.helpers.ArrayUtil;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;

public class Monitors {
    private static final FailureHandler IGNORE = (f, m) -> {};
    private final Map<Method, Set<MonitorListenerInvocationHandler>> methodMonitorListeners = new ConcurrentHashMap<Method, Set<MonitorListenerInvocationHandler>>();
    private final MutableBag<Class<?>> monitoredInterfaces = MultiReaderHashBag.newBag();
    private final Monitors parent;
    private final FailureHandler failureHandler;

    public Monitors() {
        this(null, IGNORE);
    }

    public Monitors(FailureHandler failureHandler) {
        this(null, failureHandler);
    }

    public Monitors(Monitors parent, InternalLogProvider logProvider) {
        this(parent, new LoggingFailureHandler(logProvider));
    }

    public Monitors(Monitors parent, FailureHandler failureHandler) {
        this.parent = parent;
        this.failureHandler = failureHandler;
    }

    public <T> T newMonitor(Class<T> monitorClass, String ... tags) {
        Monitors.requireInterface(monitorClass);
        ClassLoader classLoader = monitorClass.getClassLoader();
        MonitorInvocationHandler monitorInvocationHandler = new MonitorInvocationHandler(this, tags);
        return monitorClass.cast(Proxy.newProxyInstance(classLoader, new Class[]{monitorClass}, (InvocationHandler)monitorInvocationHandler));
    }

    public void addMonitorListener(Object monitorListener, String ... tags) {
        MonitorListenerInvocationHandler monitorListenerInvocationHandler = Monitors.createInvocationHandler(monitorListener, tags);
        List<Class<?>> listenerInterfaces = Monitors.getAllInterfaces(monitorListener);
        Monitors.methodsStream(listenerInterfaces).forEach(method -> {
            Set methodHandlers = this.methodMonitorListeners.computeIfAbsent((Method)method, f -> ConcurrentHashMap.newKeySet());
            methodHandlers.add(monitorListenerInvocationHandler);
        });
        this.monitoredInterfaces.addAll(listenerInterfaces);
    }

    public void removeMonitorListener(Object monitorListener) {
        List<Class<?>> listenerInterfaces = Monitors.getAllInterfaces(monitorListener);
        Monitors.methodsStream(listenerInterfaces).forEach(method -> this.cleanupMonitorListeners(monitorListener, (Method)method));
        listenerInterfaces.forEach(arg_0 -> this.monitoredInterfaces.remove(arg_0));
    }

    private void cleanupMonitorListeners(Object monitorListener, Method key) {
        this.methodMonitorListeners.computeIfPresent(key, (method1, handlers) -> {
            handlers.removeIf(handler -> monitorListener.equals(handler.getMonitorListener()));
            return handlers.isEmpty() ? null : handlers;
        });
    }

    private static List<Class<?>> getAllInterfaces(Object monitorListener) {
        return ClassUtils.getAllInterfaces(monitorListener.getClass());
    }

    private static Stream<Method> methodsStream(List<Class<?>> interfaces) {
        return interfaces.stream().map(Class::getMethods).flatMap(Arrays::stream);
    }

    private static MonitorListenerInvocationHandler createInvocationHandler(Object monitorListener, String[] tags) {
        return ArrayUtils.isEmpty((Object[])tags) ? new UntaggedMonitorListenerInvocationHandler(monitorListener) : new TaggedMonitorListenerInvocationHandler(monitorListener, tags);
    }

    private static void requireInterface(Class monitorClass) {
        if (!monitorClass.isInterface()) {
            throw new IllegalArgumentException("Interfaces should be provided.");
        }
    }

    public static interface FailureHandler {
        public void accept(Throwable var1, String var2);
    }

    public static class LoggingFailureHandler
    implements FailureHandler {
        private final InternalLog log;

        public LoggingFailureHandler(InternalLogProvider logProvider) {
            this.log = logProvider.getLog(Monitors.class);
        }

        @Override
        public void accept(Throwable failure, String method) {
            String message = String.format("Encountered exception while handling listener for monitor method %s", method);
            this.log.warn(message, failure);
        }
    }

    private static class MonitorInvocationHandler
    implements InvocationHandler {
        private final Monitors monitor;
        private final String[] tags;

        MonitorInvocationHandler(Monitors monitor, String ... tags) {
            this.monitor = monitor;
            this.tags = tags;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            MonitorInvocationHandler.invokeMonitorListeners(this.monitor, this.tags, proxy, method, args);
            Monitors current = this.monitor.parent;
            while (current != null) {
                MonitorInvocationHandler.invokeMonitorListeners(current, this.tags, proxy, method, args);
                current = current.parent;
            }
            return null;
        }

        private static void invokeMonitorListeners(Monitors monitor, String[] tags, Object proxy, Method method, Object[] args) {
            Set<MonitorListenerInvocationHandler> handlers = monitor.methodMonitorListeners.get(method);
            if (handlers == null || handlers.isEmpty()) {
                return;
            }
            for (MonitorListenerInvocationHandler monitorListenerInvocationHandler : handlers) {
                try {
                    monitorListenerInvocationHandler.invoke(proxy, method, args, tags);
                }
                catch (Throwable failure) {
                    monitor.failureHandler.accept(failure, method.getName());
                }
            }
        }
    }

    private static interface MonitorListenerInvocationHandler {
        public Object getMonitorListener();

        public void invoke(Object var1, Method var2, Object[] var3, String ... var4) throws Throwable;
    }

    private static class UntaggedMonitorListenerInvocationHandler
    implements MonitorListenerInvocationHandler {
        private final Object monitorListener;

        UntaggedMonitorListenerInvocationHandler(Object monitorListener) {
            this.monitorListener = monitorListener;
        }

        @Override
        public Object getMonitorListener() {
            return this.monitorListener;
        }

        @Override
        public void invoke(Object proxy, Method method, Object[] args, String ... tags) throws Throwable {
            method.invoke(this.monitorListener, args);
        }
    }

    private static class TaggedMonitorListenerInvocationHandler
    extends UntaggedMonitorListenerInvocationHandler {
        private final String[] tags;

        TaggedMonitorListenerInvocationHandler(Object monitorListener, String ... tags) {
            super(monitorListener);
            this.tags = tags;
        }

        @Override
        public void invoke(Object proxy, Method method, Object[] args, String ... tags) throws Throwable {
            if (ArrayUtil.containsAll((Object[])this.tags, (Object[])tags)) {
                super.invoke(proxy, method, args, tags);
            }
        }
    }
}

