/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.monitoring;

import java.util.Objects;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.InternalLog;
import org.neo4j.monitoring.HealthEventGenerator;
import org.neo4j.monitoring.OutOfDiskSpace;
import org.neo4j.monitoring.Panic;

public class DatabaseHealth
extends LifecycleAdapter
implements Panic,
OutOfDiskSpace {
    private static final String panicMessage = "The database has encountered a critical error, and needs to be restarted. Please see database logs for more details.";
    private volatile boolean hasPanic;
    private final HealthEventGenerator healthEventGenerator;
    private final InternalLog log;
    private volatile Throwable causeOfPanic;

    public DatabaseHealth(HealthEventGenerator healthEventGenerator, InternalLog log) {
        this.healthEventGenerator = healthEventGenerator;
        this.log = log;
    }

    @Override
    public <EXCEPTION extends Throwable> void assertNoPanic(Class<EXCEPTION> panicDisguise) throws EXCEPTION {
        if (this.hasPanic) {
            throw Exceptions.disguiseException(panicDisguise, (String)panicMessage, (Throwable)this.causeOfPanic);
        }
    }

    @Override
    public synchronized void panic(Throwable cause) {
        if (this.hasPanic) {
            return;
        }
        Objects.requireNonNull(cause, "Must provide a non null cause for the database panic");
        this.causeOfPanic = cause;
        this.hasPanic = true;
        this.log.error("Database panic: The database has encountered a critical error, and needs to be restarted. Please see database logs for more details.", cause);
        if (this.healthEventGenerator != null) {
            this.healthEventGenerator.panic(cause);
        }
    }

    @Override
    public boolean hasNoPanic() {
        return !this.hasPanic;
    }

    @Override
    public Throwable causeOfPanic() {
        return this.causeOfPanic;
    }

    @Override
    public void outOfDiskSpace() {
        if (this.healthEventGenerator != null) {
            this.healthEventGenerator.outOfDiskSpace();
        }
    }
}

