/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.notifications;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.gqlstatus.Condition;
import org.neo4j.gqlstatus.DiagnosticRecord;
import org.neo4j.gqlstatus.GqlStatus;
import org.neo4j.graphdb.InputPosition;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.NotificationCategory;
import org.neo4j.graphdb.NotificationClassification;
import org.neo4j.graphdb.SeverityLevel;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.notifications.NotificationCodeWithDescription;

public final class NotificationImplementation
implements Notification {
    private final Status neo4jStatus;
    private final GqlStatus gqlStatus;
    private final DiagnosticRecord diagnosticRecord;
    private final String title;
    private final String description;
    private final InputPosition position;
    private final String message;
    private final String severity;
    private final String subCondition;
    private final Condition condition;

    NotificationImplementation(NotificationCodeWithDescription notificationCodeWithDescription, GqlStatus gqlStatus, InputPosition position, String title, String description, String message, String subCondition, Condition condition, Map<String, Object> statusParameters) {
        this.neo4jStatus = notificationCodeWithDescription.getStatus();
        this.subCondition = subCondition;
        this.condition = condition;
        Status.Code statusCode = this.neo4jStatus.code();
        if (!(statusCode instanceof Status.NotificationCode)) {
            throw new IllegalStateException("'" + statusCode + "' is not a notification code.");
        }
        this.severity = ((Status.NotificationCode)statusCode).getSeverity();
        String classification = ((Status.NotificationCode)statusCode).getNotificationCategory();
        this.diagnosticRecord = new DiagnosticRecord(this.severity, classification, position.getOffset(), position.getLine(), position.getColumn(), statusParameters);
        this.gqlStatus = gqlStatus;
        this.position = position;
        this.title = title;
        this.description = description;
        this.message = message;
    }

    public Status getNeo4jStatus() {
        return this.neo4jStatus;
    }

    public String getCode() {
        return this.neo4jStatus.code().serialize();
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public InputPosition getPosition() {
        return this.position;
    }

    public NotificationCategory getCategory() {
        return this.mapCategory(this.diagnosticRecord.asMap().get("_classification").toString());
    }

    public NotificationClassification getClassification() {
        return this.mapClassification(this.diagnosticRecord.asMap().get("_classification").toString());
    }

    public SeverityLevel getSeverity() {
        return this.mapSeverity(this.diagnosticRecord.asMap().get("_severity").toString());
    }

    public String toString() {
        return "Notification{position=" + this.position + ", description='" + this.description + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationImplementation that = (NotificationImplementation)o;
        return Objects.equals(this.position, that.position) && Objects.equals(this.description, that.description) && Objects.equals(this.title, that.title) && Objects.equals(this.message, that.message) && Objects.equals(this.gqlStatus, that.gqlStatus) && Objects.equals(this.diagnosticRecord, that.diagnosticRecord);
    }

    public int hashCode() {
        return Objects.hash(this.position, this.description, this.title, this.message, this.gqlStatus, this.diagnosticRecord);
    }

    private SeverityLevel mapSeverity(String severityLevel) {
        return SeverityLevel.valueOf((String)severityLevel);
    }

    private NotificationCategory mapCategory(String category) {
        return NotificationCategory.valueOf((String)category);
    }

    private NotificationClassification mapClassification(String classification) {
        return NotificationClassification.valueOf((String)classification);
    }

    public String getMessage() {
        return this.message;
    }

    public String getGqlStatus() {
        return this.gqlStatus.gqlStatusString();
    }

    public Map<String, Object> getDiagnosticRecord() {
        return this.diagnosticRecord.asMap();
    }

    public String getStatusDescription() {
        return this.conditionToDescription(this.condition) + this.subCondition + ". " + this.message;
    }

    private String conditionToDescription(Condition condition) {
        return switch (condition) {
            default -> throw new IncompatibleClassChangeError();
            case Condition.WARNING -> "warn: ";
            case Condition.INFORMATION -> "info: ";
            case Condition.SUCCESSFUL_COMPLETION -> "note: successful completion - ";
        };
    }

    public static class NotificationBuilder {
        private final NotificationCodeWithDescription notificationCodeWithDescription;
        private final GqlStatus gqlStatus;
        private String title;
        private final String description;
        private InputPosition position;
        private final String message;
        private final String subCondition;
        private final Condition condition;
        private String[] messageParameters;
        private Map<String, Object> statusParameters;
        private String[] notificationDetails;

        public NotificationBuilder(NotificationCodeWithDescription notificationCodeWithDescription) {
            this.notificationCodeWithDescription = notificationCodeWithDescription;
            this.gqlStatus = notificationCodeWithDescription.getGqlStatus();
            this.description = notificationCodeWithDescription.getDescription();
            this.title = notificationCodeWithDescription.getStatus().code().description();
            this.position = InputPosition.empty;
            this.message = notificationCodeWithDescription.getMessage();
            this.subCondition = notificationCodeWithDescription.getSubCondition();
            this.condition = notificationCodeWithDescription.getCondition();
        }

        public NotificationBuilder setPosition(InputPosition position) {
            this.position = position;
            return this;
        }

        public NotificationBuilder setTitleDetails(String ... details) {
            if (details.length > 0) {
                this.title = String.format(this.title, details);
            }
            return this;
        }

        public NotificationBuilder setNotificationDetails(String ... details) {
            this.notificationDetails = details;
            return this;
        }

        public NotificationBuilder setMessageParameters(Object[] parameterValues) {
            Object[] parameterKeys = this.notificationCodeWithDescription.getStatusParameterKeys();
            this.statusParameters = new HashMap<String, Object>();
            this.messageParameters = new String[parameterValues.length];
            if (parameterKeys.length != parameterValues.length) {
                throw new InvalidArgumentException(String.format("Expected parameterKeys: %s and parameterValues: %s to have the same length.", Arrays.toString(parameterKeys), Arrays.toString(parameterValues)));
            }
            for (int i = 0; i < parameterKeys.length; ++i) {
                Object key = parameterKeys[i];
                Object value = parameterValues[i];
                if (value instanceof String) {
                    String s = (String)value;
                    this.statusParameters.put((String)key, value);
                    this.messageParameters[i] = s;
                    continue;
                }
                if (value instanceof Boolean) {
                    Boolean b = (Boolean)value;
                    this.statusParameters.put((String)key, value);
                    this.messageParameters[i] = b.toString();
                    continue;
                }
                if (value instanceof Integer) {
                    Integer nbr = (Integer)value;
                    this.statusParameters.put((String)key, value);
                    this.messageParameters[i] = nbr.toString();
                    continue;
                }
                if (this.isListOfString(value)) {
                    this.statusParameters.put((String)key, value);
                    this.messageParameters[i] = String.join((CharSequence)", ", (List)value);
                    continue;
                }
                throw new InvalidArgumentException(String.format("Expected parameter to be String, Boolean, Integer or List<String> but was %s", value));
            }
            return this;
        }

        private boolean isListOfString(Object obj) {
            if (!(obj instanceof List)) {
                return false;
            }
            List list = (List)obj;
            for (Object element : list) {
                if (element instanceof String) continue;
                return false;
            }
            return true;
        }

        public NotificationImplementation build() {
            String detailedDescription = this.description;
            if (this.notificationDetails != null) {
                detailedDescription = String.format(this.description, this.notificationDetails);
            }
            String detailedMessage = this.message;
            if (this.messageParameters != null) {
                detailedMessage = String.format(this.message, this.messageParameters);
            }
            return new NotificationImplementation(this.notificationCodeWithDescription, this.gqlStatus, this.position, this.title, detailedDescription, detailedMessage, this.subCondition, this.condition, this.statusParameters);
        }
    }
}

