/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.notifications;

import org.neo4j.gqlstatus.CommonGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.DiagnosticRecord;
import org.neo4j.gqlstatus.GqlStatusInfo;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.graphdb.GqlStatusObject;

public class StandardGqlStatusObject
extends CommonGqlStatusObjectImplementation
implements GqlStatusObject {
    public static final StandardGqlStatusObject SUCCESS = new StandardGqlStatusObject(GqlStatusInfoCodes.STATUS_00000);
    public static final StandardGqlStatusObject NO_DATA = new StandardGqlStatusObject(GqlStatusInfoCodes.STATUS_02000);
    public static final StandardGqlStatusObject UNKNOWN_NO_DATA = new StandardGqlStatusObject(GqlStatusInfoCodes.STATUS_02N42);
    public static final StandardGqlStatusObject OMITTED_RESULT = new StandardGqlStatusObject(GqlStatusInfoCodes.STATUS_00001);

    StandardGqlStatusObject(GqlStatusInfoCodes gqlStatusInfo) {
        super((GqlStatusInfo)gqlStatusInfo, new DiagnosticRecord());
    }

    public String toString() {
        if (this == SUCCESS) {
            return "SUCCESS";
        }
        if (this == NO_DATA) {
            return "NO DATA";
        }
        if (this == UNKNOWN_NO_DATA) {
            return "UNKNOWN NO DATA";
        }
        if (this == OMITTED_RESULT) {
            return "OMITTED RESULT";
        }
        return String.format("GqlStatusObject with GQLSTATUS %s", this.gqlStatusInfo.getStatusString());
    }

    public static boolean isStandardGqlStatusCode(GqlStatusObject gso) {
        return gso == NO_DATA || gso == SUCCESS || gso == OMITTED_RESULT || gso == UNKNOWN_NO_DATA;
    }

    public static boolean isStandardGqlStatusCode(String gqlStatus) {
        return gqlStatus.equals(NO_DATA.gqlStatus()) || gqlStatus.equals(SUCCESS.gqlStatus()) || gqlStatus.equals(OMITTED_RESULT.gqlStatus()) || gqlStatus.equals(UNKNOWN_NO_DATA.gqlStatus());
    }
}

