/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.classloader;

import org.neo4j.ogm.classloader.DefaultStrategy;
import org.neo4j.ogm.classloader.Strategy;

public abstract class ClassLoaderResolver {
    private static final Strategy strategy;
    private static final CallerResolver CALLER_RESOLVER;

    public static synchronized ClassLoader resolve() {
        return strategy.classLoader(ClassLoaderResolver.callingClass());
    }

    private static Class callingClass() {
        return CALLER_RESOLVER.getClassContext()[4];
    }

    static {
        try {
            CALLER_RESOLVER = new CallerResolver();
            strategy = new DefaultStrategy();
        }
        catch (SecurityException se) {
            throw new RuntimeException(se);
        }
    }

    private static final class CallerResolver
    extends SecurityManager {
        private CallerResolver() {
        }

        protected Class[] getClassContext() {
            return super.getClassContext();
        }
    }
}

