/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.service;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import org.neo4j.ogm.classloader.ClassLoaderResolver;
import org.neo4j.ogm.compiler.Compiler;
import org.neo4j.ogm.config.Configuration;
import org.neo4j.ogm.driver.Driver;
import org.neo4j.ogm.service.CompilerService;
import org.neo4j.ogm.service.DriverService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Components {
    private static final Logger logger = LoggerFactory.getLogger(Components.class);
    private static Configuration configuration = new Configuration();
    private static Driver driver;

    private Components() {
    }

    public static void configure(Configuration configuration) {
        Components.destroy();
        Components.configuration = configuration;
    }

    public static void configure(String configurationFileName) {
        try (InputStream is = Components.classPathResource(configurationFileName);){
            Components.configure(is);
        }
        catch (Exception e) {
            logger.warn("Could not configure OGM from {}", (Object)configurationFileName);
        }
    }

    public static synchronized Driver driver() {
        if (driver == null) {
            Components.loadDriver();
        }
        return driver;
    }

    public static synchronized Compiler compiler() {
        return Components.loadCompiler();
    }

    public static synchronized void autoConfigure() {
        try (InputStream is = Components.configurationFile();){
            Components.configure(is);
        }
        catch (Exception e) {
            logger.warn("Could not autoconfigure the OGM");
        }
    }

    private static void configure(InputStream is) throws Exception {
        configuration.clear();
        driver = null;
        Properties properties = new Properties();
        properties.load(is);
        Enumeration<?> propertyNames = properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String propertyName = (String)propertyNames.nextElement();
            configuration.set(propertyName, properties.getProperty(propertyName));
        }
    }

    private static void loadDriver() {
        if (configuration.driverConfiguration().getDriverClassName() == null) {
            Components.autoConfigure();
        }
        Components.setDriver(DriverService.load(configuration.driverConfiguration()));
    }

    private static Compiler loadCompiler() {
        if (configuration.compilerConfiguration().getCompilerClassName() == null) {
            Components.autoConfigure();
        }
        return CompilerService.load(configuration.compilerConfiguration());
    }

    private static InputStream configurationFile() throws Exception {
        String configFileName = System.getenv("ogm.properties");
        if (configFileName == null && (configFileName = System.getProperty("ogm.properties")) == null) {
            return Components.classPathResource("ogm.properties");
        }
        return Components.classPathResource(configFileName);
    }

    private static InputStream classPathResource(String name) {
        logger.debug("Trying to configure from {} ", (Object)name);
        return ClassLoaderResolver.resolve().getResourceAsStream(name);
    }

    public static void setDriver(Driver driver) {
        logger.debug("Setting driver to: {}", (Object)driver.getClass().getName());
        Components.driver = driver;
    }

    public static double neo4jVersion() {
        String neo4jVersion = (String)configuration.get("neo4j.version");
        if (neo4jVersion != null) {
            try {
                return new Double(neo4jVersion);
            }
            catch (NumberFormatException nfe) {
                logger.warn("Configuration property 'neo4j.version' is not in the correct form: expected something like '2.3'");
            }
        }
        return 9.9;
    }

    public static synchronized void destroy() {
        if (driver != null) {
            driver.close();
            driver = null;
        }
        if (configuration != null) {
            configuration.clear();
        }
    }
}

