/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.service;

import java.io.File;
import java.net.URL;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.neo4j.ogm.classloader.ResourceResolver;
import org.neo4j.ogm.exception.ServiceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceService {
    private static final Logger logger = LoggerFactory.getLogger(ResourceResolver.class);
    private static ServiceLoader<ResourceResolver> serviceLoader = ServiceLoader.load(ResourceResolver.class);

    public static File resolve(URL url) throws Exception {
        Iterator<ResourceResolver> iterator = serviceLoader.iterator();
        while (iterator.hasNext()) {
            try {
                ResourceResolver resourceResolver = iterator.next();
                File file = resourceResolver.resolve(url);
                if (file == null) continue;
                return file;
            }
            catch (ServiceConfigurationError sce) {
                logger.warn("{}, reason: {}", (Object)sce.getLocalizedMessage(), (Object)sce.getCause());
            }
        }
        throw new ServiceNotFoundException("Resource: " + url.toExternalForm());
    }
}

