/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.response.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.neo4j.ogm.model.Node;
import org.neo4j.ogm.model.Property;
import org.neo4j.ogm.response.model.PropertyModel;

public class NodeModel
implements Node {
    private Long id;
    private String[] labels;
    private String[] removedLabels;
    private List<Property<String, Object>> properties = new ArrayList<Property<String, Object>>();
    private String primaryIndex;

    @Override
    public List<Property<String, Object>> getPropertyList() {
        return this.properties;
    }

    @Override
    public String getPrimaryIndex() {
        return this.primaryIndex;
    }

    public void setPrimaryIndex(String primaryIndex) {
        this.primaryIndex = primaryIndex;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = new ArrayList<Property<String, Object>>();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            this.properties.add(new PropertyModel<String, Object>(entry.getKey(), entry.getValue()));
        }
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public String[] getLabels() {
        return this.labels;
    }

    @Override
    public String[] getRemovedLabels() {
        return this.removedLabels;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setPropertyList(List<Property<String, Object>> properties) {
        this.properties = properties;
    }

    public void setLabels(String[] labels) {
        this.labels = labels;
    }

    public void removeLabels(String[] labels) {
        this.removedLabels = labels;
    }

    public Object property(String key) {
        for (Property<String, Object> property : this.properties) {
            if (!property.getKey().equals(key)) continue;
            return property.getValue();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeModel nodeModel = (NodeModel)o;
        return this.id.equals(nodeModel.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

