/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.result.adapter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.neo4j.ogm.exception.ResultProcessingException;
import org.neo4j.ogm.model.RowModel;
import org.neo4j.ogm.response.model.DefaultRowModel;
import org.neo4j.ogm.result.adapter.AdapterUtils;
import org.neo4j.ogm.result.adapter.ResultAdapter;

public abstract class RowModelAdapter
implements ResultAdapter<Map<String, Object>, RowModel> {
    private List<String> columns = new ArrayList<String>();

    @Override
    public RowModel adapt(Map<String, Object> data) {
        if (this.columns == null) {
            throw new ResultProcessingException("Result columns should not be null");
        }
        Iterator<String> iterator = this.columns.iterator();
        ArrayList<String> variables = new ArrayList<String>();
        ArrayList<Object> values = new ArrayList<Object>();
        while (iterator.hasNext()) {
            String key = iterator.next();
            Object value = data.get(key);
            if (this.isPath(value) || this.isNode(value) || this.isRelationship(value)) continue;
            variables.add(key);
            if (value != null && value.getClass().isArray()) {
                values.add(AdapterUtils.convertToIterable(value));
            }
            values.add(value);
        }
        return new DefaultRowModel(values.toArray(new Object[0]), variables.toArray(new String[0]));
    }

    public void setColumns(List<String> columns) {
        this.columns = columns;
    }

    public abstract boolean isPath(Object var1);

    public abstract boolean isNode(Object var1);

    public abstract boolean isRelationship(Object var1);
}

