/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.config;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;
import org.neo4j.ogm.config.AutoIndexMode;
import org.neo4j.ogm.config.ConfigurationSource;
import org.neo4j.ogm.config.ConfigurationUtils;
import org.neo4j.ogm.config.Credentials;
import org.neo4j.ogm.config.Drivers;
import org.neo4j.ogm.config.UsernamePasswordCredentials;
import org.neo4j.ogm.support.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private static final Logger LOGGER = LoggerFactory.getLogger(Configuration.class);
    private static final int DEFAULT_SESSION_POOL_SIZE = 50;
    public static final ThreadLocal<ClassLoaderPrecedence> CLASS_LOADER_PRECEDENCE = ThreadLocal.withInitial(() -> ClassLoaderPrecedence.CONTEXT_CLASS_LOADER);
    private String uri;
    private String[] uris;
    private int connectionPoolSize;
    private String encryptionLevel;
    private String trustStrategy;
    private String trustCertFile;
    private AutoIndexMode autoIndex;
    private String generatedIndexesOutputDir;
    private String generatedIndexesOutputFilename;
    private String neo4jConfLocation;
    private String driverName;
    private Credentials credentials;
    private Integer connectionLivenessCheckTimeout;
    private Boolean verifyConnection;
    private Boolean useNativeTypes;
    private Map<String, Object> customProperties;
    private Boolean useStrictQuerying;
    private String[] basePackages;
    private String database;

    public static ClassLoader getDefaultClassLoader() {
        ClassLoaderPrecedence precedence = CLASS_LOADER_PRECEDENCE.get();
        boolean ctclFirst = precedence == null || precedence == ClassLoaderPrecedence.CONTEXT_CLASS_LOADER;
        ClassLoader cl = null;
        try {
            cl = ctclFirst ? Thread.currentThread().getContextClassLoader() : ClassUtils.class.getClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null) {
            ClassLoader classLoader = cl = ctclFirst ? ClassUtils.class.getClassLoader() : Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                try {
                    cl = ClassLoader.getSystemClassLoader();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return cl;
    }

    Configuration(Builder builder) {
        this.uri = builder.uri;
        this.uris = builder.uris;
        this.connectionPoolSize = builder.connectionPoolSize != null ? builder.connectionPoolSize : 50;
        this.encryptionLevel = builder.encryptionLevel;
        this.trustStrategy = builder.trustStrategy;
        this.trustCertFile = builder.trustCertFile;
        this.connectionLivenessCheckTimeout = builder.connectionLivenessCheckTimeout;
        this.verifyConnection = builder.verifyConnection != null ? builder.verifyConnection : false;
        this.autoIndex = builder.autoIndex != null ? AutoIndexMode.fromString(builder.autoIndex) : AutoIndexMode.NONE;
        this.generatedIndexesOutputDir = builder.generatedIndexesOutputDir != null ? builder.generatedIndexesOutputDir : ".";
        this.generatedIndexesOutputFilename = builder.generatedIndexesOutputFilename != null ? builder.generatedIndexesOutputFilename : "generated_indexes.cql";
        this.neo4jConfLocation = builder.neo4jConfLocation;
        this.customProperties = builder.customProperties;
        this.useNativeTypes = builder.useNativeTypes;
        this.basePackages = builder.basePackages;
        this.useStrictQuerying = builder.useStrictQuerying;
        this.database = Optional.ofNullable(builder.database).map(String::trim).filter(s -> !s.isEmpty()).orElse(null);
        URI parsedUri = this.getSingleURI();
        if (parsedUri != null) {
            this.parseAndSetParametersFromURI(parsedUri);
        } else {
            this.driverName = Drivers.EMBEDDED.driverClassName();
        }
        if (builder.username != null && builder.password != null) {
            if (this.credentials != null) {
                LOGGER.warn("Overriding credentials supplied in URI with supplied username and password.");
            }
            this.credentials = new UsernamePasswordCredentials(builder.username, builder.password);
        }
    }

    private void parseAndSetParametersFromURI(URI parsedUri) {
        String userInfo = parsedUri.getUserInfo();
        if (userInfo != null) {
            String[] userPass = userInfo.split(":");
            this.credentials = new UsernamePasswordCredentials(userPass[0], userPass[1]);
            this.uri = parsedUri.toString().replace(parsedUri.getUserInfo() + "@", "");
        }
        if (this.getDriverClassName() == null) {
            this.driverName = Drivers.getDriverFor(parsedUri.getScheme()).driverClassName();
        }
    }

    private URI getSingleURI() {
        try {
            if (this.uri != null) {
                return new URI(this.uri);
            }
            if (this.uris != null && this.uris.length >= 1) {
                return new URI(this.uris[0]);
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Could not configure supplied URI in Configuration", e);
        }
        return null;
    }

    public AutoIndexMode getAutoIndex() {
        return this.autoIndex;
    }

    public String getDumpDir() {
        return this.generatedIndexesOutputDir;
    }

    public String getDumpFilename() {
        return this.generatedIndexesOutputFilename;
    }

    public String getURI() {
        return this.uri;
    }

    public String[] getURIS() {
        return this.uris;
    }

    public String getDriverClassName() {
        return this.driverName;
    }

    public int getConnectionPoolSize() {
        return this.connectionPoolSize;
    }

    public String getEncryptionLevel() {
        return this.encryptionLevel;
    }

    public String getTrustStrategy() {
        return this.trustStrategy;
    }

    public String getTrustCertFile() {
        return this.trustCertFile;
    }

    public Integer getConnectionLivenessCheckTimeout() {
        return this.connectionLivenessCheckTimeout;
    }

    public Boolean getVerifyConnection() {
        return this.verifyConnection;
    }

    public String getNeo4jConfLocation() {
        return this.neo4jConfLocation;
    }

    public String getDatabase() {
        return this.database;
    }

    public boolean isEmbeddedHA() {
        boolean isEmbeddedHA = false;
        if (this.neo4jConfLocation != null) {
            try {
                URL url = ConfigurationUtils.getResourceUrl(this.neo4jConfLocation);
                Properties neo4Properties = new Properties();
                neo4Properties.load(url.openStream());
                isEmbeddedHA = "HA".equalsIgnoreCase(neo4Properties.getProperty("dbms.mode", "-"));
            }
            catch (IOException e) {
                throw new UncheckedIOException("Could not load neo4j.conf at location " + this.neo4jConfLocation, e);
            }
        }
        return isEmbeddedHA;
    }

    public URL getResourceUrl(String resourceLocation) throws FileNotFoundException {
        return ConfigurationUtils.getResourceUrl(resourceLocation);
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public Map<String, Object> getCustomProperties() {
        return Collections.unmodifiableMap(this.customProperties);
    }

    public Boolean getUseNativeTypes() {
        return this.useNativeTypes;
    }

    public Boolean getUseStrictQuerying() {
        return this.useStrictQuerying;
    }

    public String[] getBasePackages() {
        return this.basePackages;
    }

    public String[] mergeBasePackagesWith(String ... anotherSetOfBasePackages) {
        String[] set1 = Optional.ofNullable(this.basePackages).orElseGet(() -> new String[0]);
        String[] set2 = Optional.ofNullable(anotherSetOfBasePackages).orElseGet(() -> new String[0]);
        return (String[])Stream.concat(Arrays.stream(set1), Arrays.stream(set2)).filter(s -> s != null).distinct().toArray(String[]::new);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Configuration)) {
            return false;
        }
        Configuration that = (Configuration)o;
        return this.connectionPoolSize == that.connectionPoolSize && Objects.equals(this.uri, that.uri) && Arrays.equals(this.uris, that.uris) && Objects.equals(this.encryptionLevel, that.encryptionLevel) && Objects.equals(this.trustStrategy, that.trustStrategy) && Objects.equals(this.trustCertFile, that.trustCertFile) && this.autoIndex == that.autoIndex && Objects.equals(this.generatedIndexesOutputDir, that.generatedIndexesOutputDir) && Objects.equals(this.generatedIndexesOutputFilename, that.generatedIndexesOutputFilename) && Objects.equals(this.neo4jConfLocation, that.neo4jConfLocation) && Objects.equals(this.driverName, that.driverName) && Objects.equals(this.credentials, that.credentials) && Objects.equals(this.connectionLivenessCheckTimeout, that.connectionLivenessCheckTimeout) && Objects.equals(this.verifyConnection, that.verifyConnection) && Objects.equals(this.useNativeTypes, that.useNativeTypes) && Arrays.equals(this.basePackages, that.basePackages) && Objects.equals(this.useStrictQuerying, that.useStrictQuerying);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.uri, this.connectionPoolSize, this.encryptionLevel, this.trustStrategy, this.trustCertFile, this.autoIndex, this.generatedIndexesOutputDir, this.generatedIndexesOutputFilename, this.neo4jConfLocation, this.driverName, this.credentials, this.connectionLivenessCheckTimeout, this.verifyConnection, this.useNativeTypes});
        result = 31 * result + Arrays.hashCode(this.uris);
        result = 31 * result + Arrays.hashCode(this.basePackages);
        return result;
    }

    public static class Builder {
        private static final String URI = "URI";
        private static final String URIS = "URIS";
        private static final String USERNAME = "username";
        private static final String PASSWORD = "password";
        private static final String CONNECTION_POOL_SIZE = "connection.pool.size";
        private static final String ENCRYPTION_LEVEL = "encryption.level";
        private static final String TRUST_STRATEGY = "trust.strategy";
        private static final String TRUST_CERT_FILE = "trust.certificate.file";
        private static final String CONNECTION_LIVENESS_CHECK_TIMEOUT = "connection.liveness.check.timeout";
        private static final String VERIFY_CONNECTION = "verify.connection";
        private static final String AUTO_INDEX = "indexes.auto";
        private static final String GENERATED_INDEXES_OUTPUT_DIR = "indexes.auto.dump.dir";
        private static final String GENERATED_INDEXES_OUTPUT_FILENAME = "indexes.auto.dump.filename";
        private static final String NEO4J_CONF_LOCATION = "neo4j.conf.location";
        private static final String USE_NATIVE_TYPES = "use-native-types";
        private static final String BASE_PACKAGES = "base-packages";
        private static final String USE_STRICT_QUERYING = "use-strict-querying";
        private static final String DATABASE = "database";
        private String uri;
        private String[] uris;
        private Integer connectionPoolSize;
        private String encryptionLevel;
        private String trustStrategy;
        private String trustCertFile;
        private Integer connectionLivenessCheckTimeout;
        private Boolean verifyConnection;
        private String autoIndex;
        private String generatedIndexesOutputDir;
        private String generatedIndexesOutputFilename;
        private String neo4jConfLocation;
        private String username;
        private String password;
        private boolean useNativeTypes;
        private Map<String, Object> customProperties = new HashMap<String, Object>();
        private String[] basePackages;
        private boolean useStrictQuerying = false;
        private String database;

        public Builder() {
        }

        public Builder(ConfigurationSource configurationSource) {
            block40: for (Map.Entry<Object, Object> entry : configurationSource.properties().entrySet()) {
                String value = (String)entry.getValue();
                switch (entry.getKey().toString()) {
                    case "URI": {
                        this.uri = value;
                        continue block40;
                    }
                    case "username": {
                        this.username = value;
                        continue block40;
                    }
                    case "password": {
                        this.password = value;
                        continue block40;
                    }
                    case "URIS": {
                        this.uris = Builder.splitValue(entry.getValue());
                        continue block40;
                    }
                    case "connection.pool.size": {
                        this.connectionPoolSize = Integer.parseInt(value);
                        continue block40;
                    }
                    case "encryption.level": {
                        this.encryptionLevel = value;
                        continue block40;
                    }
                    case "trust.strategy": {
                        this.trustStrategy = value;
                        continue block40;
                    }
                    case "trust.certificate.file": {
                        this.trustCertFile = value;
                        continue block40;
                    }
                    case "connection.liveness.check.timeout": {
                        this.connectionLivenessCheckTimeout = Integer.valueOf(value);
                        continue block40;
                    }
                    case "verify.connection": {
                        this.verifyConnection = Boolean.valueOf(value);
                        continue block40;
                    }
                    case "indexes.auto": {
                        this.autoIndex = value;
                        continue block40;
                    }
                    case "indexes.auto.dump.dir": {
                        this.generatedIndexesOutputDir = value;
                        continue block40;
                    }
                    case "indexes.auto.dump.filename": {
                        this.generatedIndexesOutputFilename = value;
                        continue block40;
                    }
                    case "neo4j.conf.location": {
                        this.neo4jConfLocation = value;
                        continue block40;
                    }
                    case "use-native-types": {
                        this.useNativeTypes = Boolean.valueOf(value);
                        continue block40;
                    }
                    case "base-packages": {
                        this.basePackages = Builder.splitValue(entry.getValue());
                        continue block40;
                    }
                    case "use-strict-querying": {
                        if (value == null || value.isEmpty()) continue block40;
                        this.useStrictQuerying = Boolean.valueOf(value);
                        continue block40;
                    }
                    case "database": {
                        if (value == null || value.trim().isEmpty()) continue block40;
                        this.database = value.trim();
                        continue block40;
                    }
                }
                LOGGER.warn("Could not process property with key: {}", entry.getKey());
            }
        }

        public static Builder copy(Builder builder) {
            Builder copiedBuilder = new Builder().uri(builder.uri).connectionPoolSize(builder.connectionPoolSize).encryptionLevel(builder.encryptionLevel).trustStrategy(builder.trustStrategy).trustCertFile(builder.trustCertFile).connectionLivenessCheckTimeout(builder.connectionLivenessCheckTimeout).verifyConnection(builder.verifyConnection).autoIndex(builder.autoIndex).generatedIndexesOutputDir(builder.generatedIndexesOutputDir).generatedIndexesOutputFilename(builder.generatedIndexesOutputFilename).neo4jConfLocation(builder.neo4jConfLocation).credentials(builder.username, builder.password).database(builder.database).customProperties(new HashMap<String, Object>(builder.customProperties));
            if (builder.useStrictQuerying) {
                copiedBuilder.strictQuerying();
            } else {
                copiedBuilder.relaxedQuerying();
            }
            return copiedBuilder;
        }

        private static String[] splitValue(Object value) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("Cannot split values of type other than java.lang.String (was " + value.getClass() + ").");
            }
            String stringValue = (String)value;
            if (stringValue == null || stringValue.trim().isEmpty()) {
                return new String[0];
            }
            return (String[])Arrays.stream(stringValue.split(",")).map(String::trim).toArray(String[]::new);
        }

        public Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public Builder uris(String[] uris) {
            this.uris = uris;
            return this;
        }

        public Builder connectionPoolSize(Integer connectionPoolSize) {
            this.connectionPoolSize = connectionPoolSize;
            return this;
        }

        public Builder encryptionLevel(String encryptionLevel) {
            this.encryptionLevel = encryptionLevel;
            return this;
        }

        public Builder trustStrategy(String trustStrategy) {
            this.trustStrategy = trustStrategy;
            return this;
        }

        public Builder trustCertFile(String trustCertFile) {
            this.trustCertFile = trustCertFile;
            return this;
        }

        public Builder connectionLivenessCheckTimeout(Integer connectionLivenessCheckTimeout) {
            this.connectionLivenessCheckTimeout = connectionLivenessCheckTimeout;
            return this;
        }

        public Builder verifyConnection(Boolean verifyConnection) {
            this.verifyConnection = verifyConnection;
            return this;
        }

        public Builder autoIndex(String autoIndex) {
            this.autoIndex = autoIndex;
            return this;
        }

        public Builder generatedIndexesOutputDir(String generatedIndexesOutputDir) {
            this.generatedIndexesOutputDir = generatedIndexesOutputDir;
            return this;
        }

        public Builder generatedIndexesOutputFilename(String generatedIndexesOutputFilename) {
            this.generatedIndexesOutputFilename = generatedIndexesOutputFilename;
            return this;
        }

        public Builder neo4jConfLocation(String neo4jConfLocation) {
            this.neo4jConfLocation = neo4jConfLocation;
            return this;
        }

        private Builder customProperties(Map<String, Object> customProperties) {
            this.customProperties = customProperties;
            return this;
        }

        public Builder withCustomProperty(String name, Object value) {
            this.customProperties.put(name, value);
            return this;
        }

        public Builder useNativeTypes() {
            this.useNativeTypes = true;
            return this;
        }

        public Builder strictQuerying() {
            this.useStrictQuerying = true;
            return this;
        }

        public Builder relaxedQuerying() {
            this.useStrictQuerying = false;
            return this;
        }

        public Builder withBasePackages(String ... basePackages) {
            this.basePackages = basePackages;
            return this;
        }

        public Builder database(String database) {
            this.database = database;
            return this;
        }

        public Configuration build() {
            return new Configuration(this);
        }

        public Builder credentials(String username, String password) {
            this.username = username;
            this.password = password;
            return this;
        }
    }

    public static enum ClassLoaderPrecedence {
        CONTEXT_CLASS_LOADER,
        OGM_CLASS_LOADER;

    }
}

