/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.response.model;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.neo4j.ogm.model.Edge;
import org.neo4j.ogm.model.GraphModel;
import org.neo4j.ogm.model.Node;
import org.neo4j.ogm.response.model.NodeModel;
import org.neo4j.ogm.response.model.RelationshipModel;

public class DefaultGraphModel
implements GraphModel {
    private final Map<Long, Node> nodes = new LinkedHashMap<Long, Node>();
    private final Map<Long, Edge> relationships = new LinkedHashMap<Long, Edge>();

    @Override
    public Collection<Node> getNodes() {
        return this.nodes.values();
    }

    public void addNode(NodeModel node) {
        this.nodes.put(node.getId(), node);
    }

    public void addRelationship(RelationshipModel edge) {
        this.relationships.put(edge.getId(), edge);
    }

    public void addNodes(NodeModel[] additionalNodes) {
        for (NodeModel node : additionalNodes) {
            this.nodes.put(node.getId(), node);
        }
    }

    @Override
    public Collection<Edge> getRelationships() {
        return this.relationships.values();
    }

    public void addRelationships(RelationshipModel[] additionalRelationships) {
        for (RelationshipModel relationship : additionalRelationships) {
            this.relationships.put(relationship.getId(), relationship);
        }
    }

    public Optional<Node> findNode(Long nodeId) {
        return Optional.ofNullable(this.nodes.get(nodeId));
    }
}

