/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.config;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.ogm.config.ConfigurationUtils;

public class ConfigurationUtilsTest {
    @Test
    void protocollessUrlsShouldBeTreatedAsClasspathUrls() throws FileNotFoundException {
        URL url = ConfigurationUtils.getResourceUrl((String)"some.properties");
        Assertions.assertThat((URL)url).isNotNull();
    }

    @Test
    void absoluteUrlsShouldWorkWith() throws FileNotFoundException {
        URL url = ConfigurationUtils.getResourceUrl((String)"/some.properties");
        Assertions.assertThat((URL)url).isNotNull();
    }

    @Test
    void classpathUrlsShouldWork() throws FileNotFoundException {
        URL url = ConfigurationUtils.getResourceUrl((String)"classpath:some.properties");
        Assertions.assertThat((URL)url).isNotNull();
    }

    @Test
    void absoluteUrlsShouldWorkWithProtocol() throws FileNotFoundException {
        URL url = ConfigurationUtils.getResourceUrl((String)"classpath:/some.properties");
        Assertions.assertThat((URL)url).isNotNull();
    }

    @Test
    void fileUrlsShouldWork() throws IOException {
        Path path = Files.createTempFile("ResourceUtilsTest", ".properties", new FileAttribute[0]);
        URL url = ConfigurationUtils.getResourceUrl((String)path.toUri().toURL().toString());
        Assertions.assertThat((URL)url).isNotNull();
    }

    @Test
    void shouldThrowFileNotFoundOnInvalidUrls() {
        Assertions.assertThatExceptionOfType(FileNotFoundException.class).isThrownBy(() -> ConfigurationUtils.getResourceUrl((String)"invalid://test.com"));
    }

    @Test
    void shouldThrowFileNotFoundOnInvalidResources() {
        Assertions.assertThatExceptionOfType(FileNotFoundException.class).isThrownBy(() -> ConfigurationUtils.getResourceUrl((String)"idontexists"));
    }
}

