/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.bolt.driver;

import java.io.File;
import java.net.URI;
import org.neo4j.driver.v1.AuthToken;
import org.neo4j.driver.v1.AuthTokens;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.GraphDatabase;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.ogm.authentication.UsernamePasswordCredentials;
import org.neo4j.ogm.config.DriverConfiguration;
import org.neo4j.ogm.driver.AbstractConfigurableDriver;
import org.neo4j.ogm.drivers.bolt.request.BoltRequest;
import org.neo4j.ogm.drivers.bolt.transaction.BoltTransaction;
import org.neo4j.ogm.exception.ConnectionException;
import org.neo4j.ogm.request.Request;
import org.neo4j.ogm.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoltDriver
extends AbstractConfigurableDriver {
    private Driver boltDriver;
    private final Logger LOGGER = LoggerFactory.getLogger(BoltDriver.class);

    public BoltDriver() {
    }

    public BoltDriver(DriverConfiguration driverConfiguration) {
        this.configure(driverConfiguration);
    }

    public void configure(DriverConfiguration config) {
        this.close();
        super.configure(config);
        Config driverConfig = this.buildDriverConfig(config);
        if (config.getCredentials() != null) {
            UsernamePasswordCredentials credentials = (UsernamePasswordCredentials)config.getCredentials();
            AuthToken authToken = AuthTokens.basic((String)credentials.getUsername(), (String)credentials.getPassword());
            this.boltDriver = GraphDatabase.driver((String)config.getURI(), (AuthToken)authToken, (Config)driverConfig);
        } else {
            this.boltDriver = GraphDatabase.driver((String)config.getURI(), (Config)driverConfig);
            this.LOGGER.debug("Bolt Driver credentials not supplied");
        }
    }

    public org.neo4j.ogm.transaction.Transaction newTransaction() {
        return this.newTransaction(Transaction.Type.READ_WRITE);
    }

    public org.neo4j.ogm.transaction.Transaction newTransaction(Transaction.Type type) {
        Session session = this.newSession();
        return new BoltTransaction(this.transactionManager, this.nativeTransaction(session), session, type);
    }

    public synchronized void close() {
        if (this.boltDriver != null) {
            try {
                this.LOGGER.info("Shutting down Bolt driver {} ", (Object)this.boltDriver);
                this.boltDriver.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Request request() {
        return new BoltRequest(this.transactionManager);
    }

    private Session newSession() {
        Session boltSession;
        try {
            boltSession = this.boltDriver.session();
        }
        catch (ClientException ce) {
            throw new ConnectionException("Error connecting to graph database using Bolt: " + ce.neo4jErrorCode() + ", " + ce.getMessage(), (Throwable)ce);
        }
        catch (Exception e) {
            throw new ConnectionException("Error connecting to graph database using Bolt", (Throwable)e);
        }
        return boltSession;
    }

    private Transaction nativeTransaction(Session session) {
        Transaction nativeTransaction;
        org.neo4j.ogm.transaction.Transaction tx = this.transactionManager.getCurrentTransaction();
        if (tx != null) {
            this.LOGGER.debug("Using current transaction: {}", (Object)tx);
            nativeTransaction = ((BoltTransaction)tx).nativeBoltTransaction();
        } else {
            this.LOGGER.debug("No current transaction, starting a new one");
            nativeTransaction = session.beginTransaction();
        }
        this.LOGGER.debug("Native transaction: {}", (Object)nativeTransaction);
        return nativeTransaction;
    }

    private BoltConfig getBoltConfiguration(DriverConfiguration driverConfiguration) {
        BoltConfig boltConfig = new BoltConfig();
        if (driverConfiguration.getEncryptionLevel() != null) {
            try {
                boltConfig.encryptionLevel = Config.EncryptionLevel.valueOf((String)driverConfiguration.getEncryptionLevel().toUpperCase());
            }
            catch (IllegalArgumentException iae) {
                this.LOGGER.debug("Invalid configuration for the Bolt Driver Encryption Level: {}", (Object)driverConfiguration.getEncryptionLevel());
                throw iae;
            }
        }
        if (driverConfiguration.getConnectionPoolSize() != null) {
            boltConfig.sessionPoolSize = driverConfiguration.getConnectionPoolSize();
        }
        if (driverConfiguration.getTrustStrategy() != null) {
            try {
                boltConfig.trustStrategy = Config.TrustStrategy.Strategy.valueOf((String)driverConfiguration.getTrustStrategy());
            }
            catch (IllegalArgumentException iae) {
                this.LOGGER.debug("Invalid configuration for the Bolt Driver Trust Strategy: {}", (Object)driverConfiguration.getTrustStrategy());
                throw iae;
            }
        }
        if (driverConfiguration.getTrustCertFile() != null) {
            boltConfig.trustCertFile = driverConfiguration.getTrustCertFile();
        }
        if (driverConfiguration.getConnectionLivenessCheckTimeout() != null) {
            boltConfig.connectionLivenessCheckTimeout = driverConfiguration.getConnectionLivenessCheckTimeout();
        }
        return boltConfig;
    }

    private Config buildDriverConfig(DriverConfiguration driverConfig) {
        try {
            BoltConfig boltConfig = this.getBoltConfiguration(driverConfig);
            Config.ConfigBuilder configBuilder = Config.build();
            configBuilder.withMaxSessions(boltConfig.sessionPoolSize);
            configBuilder.withEncryptionLevel(boltConfig.encryptionLevel);
            if (boltConfig.connectionLivenessCheckTimeout != null) {
                configBuilder.withSessionLivenessCheckTimeout((long)boltConfig.connectionLivenessCheckTimeout.intValue());
            }
            if (boltConfig.trustStrategy != null) {
                if (boltConfig.trustCertFile == null) {
                    throw new IllegalArgumentException("Missing configuration value for trust.certificate.file");
                }
                if (boltConfig.trustStrategy.equals((Object)Config.TrustStrategy.Strategy.TRUST_ON_FIRST_USE)) {
                    configBuilder.withTrustStrategy(Config.TrustStrategy.trustOnFirstUse((File)new File(new URI(boltConfig.trustCertFile))));
                }
                if (boltConfig.trustStrategy.equals((Object)Config.TrustStrategy.Strategy.TRUST_SIGNED_CERTIFICATES)) {
                    configBuilder.withTrustStrategy(Config.TrustStrategy.trustSignedBy((File)new File(new URI(boltConfig.trustCertFile))));
                }
            }
            return configBuilder.toConfig();
        }
        catch (Exception e) {
            throw new ConnectionException("Unable to build driver configuration", (Throwable)e);
        }
    }

    class BoltConfig {
        public static final int DEFAULT_SESSION_POOL_SIZE = 50;
        Config.EncryptionLevel encryptionLevel = Config.EncryptionLevel.REQUIRED;
        int sessionPoolSize = 50;
        Config.TrustStrategy.Strategy trustStrategy;
        String trustCertFile;
        Integer connectionLivenessCheckTimeout;

        BoltConfig() {
        }
    }
}

